/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.InsertIntoDesc;
import net.esper.eql.spec.SelectExprElementCompiledSpec;
import net.esper.eql.spec.SelectExprElementStreamCompiledSpec;
import net.esper.event.DecoratingEventBean;
import net.esper.event.EventAdapterException;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.event.TaggedCompositeEventBean;
import net.esper.event.TaggedCompositeEventType;
import net.esper.event.WrapperEventType;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprEvalProcessorStreams
implements SelectExprProcessor {
    private static final Log log = LogFactory.getLog(SelectExprEvalProcessorStreams.class);
    private final EventAdapterService eventAdapterService;
    private final List<SelectExprElementStreamCompiledSpec> aliasedStreams;
    private final List<SelectExprElementStreamCompiledSpec> unaliasedStreams;
    private boolean singleStreamWrapper;
    private boolean isUsingWildcard;
    private ExprNode[] expressionNodes;
    private String[] columnNames;
    private EventType resultEventType;
    private EventType underlyingEventType;
    private int underlyingStreamNumber;
    private boolean underlyingIsTaggedEvent;

    public SelectExprEvalProcessorStreams(List<SelectExprElementCompiledSpec> selectionList, List<SelectExprElementStreamCompiledSpec> selectedStreams, InsertIntoDesc insertIntoDesc, boolean isUsingWildcard, StreamTypeService typeService, EventAdapterService eventAdapterService) throws ExprValidationException {
        this.eventAdapterService = eventAdapterService;
        this.isUsingWildcard = isUsingWildcard;
        this.unaliasedStreams = new ArrayList<SelectExprElementStreamCompiledSpec>();
        this.aliasedStreams = new ArrayList<SelectExprElementStreamCompiledSpec>();
        for (SelectExprElementStreamCompiledSpec spec : selectedStreams) {
            if (spec.getOptionalAliasName() == null) {
                this.unaliasedStreams.add(spec);
                continue;
            }
            this.aliasedStreams.add(spec);
        }
        if (insertIntoDesc != null) {
            SelectExprEvalProcessorStreams.verifyInsertInto(insertIntoDesc, selectionList, this.aliasedStreams, isUsingWildcard, typeService);
        }
        if (this.unaliasedStreams.size() > 1) {
            throw new ExprValidationException("A column alias must be supplied for all but one stream if multiple streams are selected via the stream.* notation");
        }
        if (isUsingWildcard || !this.unaliasedStreams.isEmpty()) {
            if (!this.unaliasedStreams.isEmpty()) {
                this.underlyingStreamNumber = this.unaliasedStreams.get(0).getStreamNumber();
                if (this.unaliasedStreams.get(0).isTaggedEvent()) {
                    TaggedCompositeEventType comp = (TaggedCompositeEventType)((Object)typeService.getEventTypes()[this.underlyingStreamNumber]);
                    this.underlyingEventType = comp.getTaggedEventTypes().get(this.unaliasedStreams.get(0).getStreamAliasName());
                    this.underlyingIsTaggedEvent = true;
                } else {
                    this.underlyingEventType = typeService.getEventTypes()[this.underlyingStreamNumber];
                }
            } else if (typeService.getEventTypes().length == 1) {
                this.underlyingEventType = typeService.getEventTypes()[0];
                if (this.underlyingEventType instanceof WrapperEventType) {
                    this.singleStreamWrapper = true;
                }
            } else {
                this.underlyingEventType = null;
            }
        }
        this.init(selectionList, this.aliasedStreams, insertIntoDesc, eventAdapterService, typeService);
    }

    private void init(List<SelectExprElementCompiledSpec> selectionList, List<SelectExprElementStreamCompiledSpec> aliasedStreams, InsertIntoDesc insertIntoDesc, EventAdapterService eventAdapterService, StreamTypeService typeService) throws ExprValidationException {
        int count;
        this.expressionNodes = new ExprNode[selectionList.size()];
        for (int i = 0; i < selectionList.size(); ++i) {
            this.expressionNodes[i] = selectionList.get(i).getSelectExpression();
        }
        if (insertIntoDesc != null && !insertIntoDesc.getColumnNames().isEmpty()) {
            this.columnNames = insertIntoDesc.getColumnNames().toArray(new String[0]);
        } else {
            int numStreamColumnsJoin = 0;
            if (this.isUsingWildcard && typeService.getEventTypes().length > 1) {
                numStreamColumnsJoin = typeService.getEventTypes().length;
            }
            this.columnNames = new String[selectionList.size() + aliasedStreams.size() + numStreamColumnsJoin];
            count = 0;
            for (SelectExprElementCompiledSpec selectExprElementCompiledSpec : selectionList) {
                this.columnNames[count] = selectExprElementCompiledSpec.getAssignedName();
                ++count;
            }
            for (SelectExprElementStreamCompiledSpec selectExprElementStreamCompiledSpec : aliasedStreams) {
                this.columnNames[count] = selectExprElementStreamCompiledSpec.getOptionalAliasName();
                ++count;
            }
            if (this.isUsingWildcard && typeService.getEventTypes().length > 1) {
                Object[] arr$ = typeService.getStreamNames();
                int n = arr$.length;
                for (int i$ = 0; i$ < n; ++i$) {
                    Object streamName;
                    this.columnNames[count] = streamName = arr$[i$];
                    ++count;
                }
            }
        }
        HashMap<String, Class> selPropertyTypes = new HashMap<String, Class>();
        count = 0;
        for (ExprNode expressionNode : this.expressionNodes) {
            Class expressionReturnType = expressionNode.getType();
            selPropertyTypes.put(this.columnNames[count], expressionReturnType);
            ++count;
        }
        for (SelectExprElementStreamCompiledSpec selectExprElementStreamCompiledSpec : aliasedStreams) {
            EventType eventTypeStream = typeService.getEventTypes()[selectExprElementStreamCompiledSpec.getStreamNumber()];
            Class expressionReturnType = eventTypeStream.getUnderlyingType();
            selPropertyTypes.put(this.columnNames[count], expressionReturnType);
            ++count;
        }
        if (this.isUsingWildcard && typeService.getEventTypes().length > 1) {
            for (int i = 0; i < typeService.getEventTypes().length; ++i) {
                EventType eventType = typeService.getEventTypes()[i];
                Class expressionReturnType = eventType.getUnderlyingType();
                selPropertyTypes.put(this.columnNames[count], expressionReturnType);
                ++count;
            }
        }
        if (insertIntoDesc != null) {
            try {
                if (this.underlyingEventType != null) {
                    this.resultEventType = eventAdapterService.addWrapperType(insertIntoDesc.getEventTypeAlias(), this.underlyingEventType, selPropertyTypes);
                }
                this.resultEventType = eventAdapterService.addMapType(insertIntoDesc.getEventTypeAlias(), selPropertyTypes);
            }
            catch (EventAdapterException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
        } else {
            this.resultEventType = this.underlyingEventType != null ? eventAdapterService.createAnonymousWrapperType(this.underlyingEventType, selPropertyTypes) : eventAdapterService.createAnonymousMapType(selPropertyTypes);
        }
        if (log.isDebugEnabled()) {
            log.debug(".init resultEventType=" + this.resultEventType);
        }
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        int count = 0;
        for (ExprNode expressionNode : this.expressionNodes) {
            Object evalResult = expressionNode.evaluate(eventsPerStream, isNewData);
            props.put(this.columnNames[count], evalResult);
            ++count;
        }
        for (SelectExprElementStreamCompiledSpec element : this.aliasedStreams) {
            Object value = eventsPerStream[element.getStreamNumber()].getUnderlying();
            props.put(this.columnNames[count], value);
            ++count;
        }
        if (this.isUsingWildcard && eventsPerStream.length > 1) {
            for (EventBean anEventsPerStream : eventsPerStream) {
                Object value = anEventsPerStream.getUnderlying();
                props.put(this.columnNames[count], value);
                ++count;
            }
        }
        if (this.underlyingEventType != null) {
            EventBean event;
            DecoratingEventBean wrapper;
            if (this.singleStreamWrapper && (wrapper = (DecoratingEventBean)((Object)eventsPerStream[0])) != null) {
                Map<String, Object> map = wrapper.getDecoratingProperties();
                if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                    log.debug(".process additional properties=" + map);
                }
                props.putAll(map);
            }
            if (this.underlyingIsTaggedEvent) {
                TaggedCompositeEventBean eventBean = (TaggedCompositeEventBean)((Object)eventsPerStream[this.underlyingStreamNumber]);
                event = eventBean.getEventBean(this.unaliasedStreams.get(0).getStreamAliasName());
            } else {
                event = eventsPerStream[this.underlyingStreamNumber];
            }
            return this.eventAdapterService.createWrapper(event, props, this.resultEventType);
        }
        return this.eventAdapterService.createMapFromValues(props, this.resultEventType);
    }

    @Override
    public EventType getResultEventType() {
        return this.resultEventType;
    }

    private static void verifyInsertInto(InsertIntoDesc insertIntoDesc, List<SelectExprElementCompiledSpec> selectionList, List<SelectExprElementStreamCompiledSpec> aliasedStreams, boolean isUsingWildcard, StreamTypeService typeService) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (String element : insertIntoDesc.getColumnNames()) {
            if (names.contains(element)) {
                throw new ExprValidationException("Property name '" + element + "' appears more then once in insert-into clause");
            }
            names.add(element);
        }
        int numStreamColumnsJoin = 0;
        if (isUsingWildcard && typeService.getEventTypes().length > 1) {
            numStreamColumnsJoin = typeService.getEventTypes().length;
        }
        if (!insertIntoDesc.getColumnNames().isEmpty() && insertIntoDesc.getColumnNames().size() != selectionList.size() + aliasedStreams.size()) {
            throw new ExprValidationException("Number of supplied values in the select clause does not match insert-into clause");
        }
    }
}

