/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.HashMap;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.InsertIntoDesc;
import net.esper.event.EventAdapterException;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventType;

public class SelectExprJoinWildcardProcessor
implements SelectExprProcessor {
    private final String[] streamNames;
    private final EventType resultEventType;
    private final EventAdapterService eventAdapterService;

    public SelectExprJoinWildcardProcessor(String[] streamNames, EventType[] streamTypes, EventAdapterService eventAdapterService, InsertIntoDesc insertIntoDesc) throws ExprValidationException {
        if (streamNames.length < 2 || streamTypes.length < 2 || streamNames.length != streamTypes.length) {
            throw new IllegalArgumentException("Stream names and types parameter length is invalid, expected use of this class is for join statements");
        }
        this.streamNames = streamNames;
        this.eventAdapterService = eventAdapterService;
        HashMap<String, Class> eventTypeMap = new HashMap<String, Class>();
        for (int i = 0; i < streamTypes.length; ++i) {
            eventTypeMap.put(streamNames[i], streamTypes[i].getUnderlyingType());
        }
        if (insertIntoDesc != null) {
            try {
                this.resultEventType = eventAdapterService.addMapType(insertIntoDesc.getEventTypeAlias(), eventTypeMap);
            }
            catch (EventAdapterException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
        } else {
            this.resultEventType = eventAdapterService.createAnonymousMapType(eventTypeMap);
        }
    }

    public EventBean process(EventBean[] eventsPerStream, boolean isNewData) {
        HashMap<String, Object> tuple = new HashMap<String, Object>();
        for (int i = 0; i < this.streamNames.length; ++i) {
            if (this.streamNames[i] == null) {
                throw new IllegalStateException("Event name for stream " + i + " is null");
            }
            if (eventsPerStream[i] != null) {
                tuple.put(this.streamNames[i], eventsPerStream[i].getUnderlying());
                continue;
            }
            tuple.put(this.streamNames[i], null);
        }
        return this.eventAdapterService.createMapFromValues(tuple, this.resultEventType);
    }

    public EventType getResultEventType() {
        return this.resultEventType;
    }
}

