/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.HashSet;
import java.util.List;
import net.esper.eql.core.SelectExprEvalProcessor;
import net.esper.eql.core.SelectExprEvalProcessorStreams;
import net.esper.eql.core.SelectExprJoinWildcardProcessor;
import net.esper.eql.core.SelectExprProcessor;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.InsertIntoDesc;
import net.esper.eql.spec.SelectExprElementCompiledSpec;
import net.esper.eql.spec.SelectExprElementStreamCompiledSpec;
import net.esper.event.EventAdapterService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExprProcessorFactory {
    private static final Log log = LogFactory.getLog(SelectExprProcessorFactory.class);

    public static SelectExprProcessor getProcessor(List<SelectExprElementCompiledSpec> selectionList, List<SelectExprElementStreamCompiledSpec> selectedStreams, boolean isUsingWildcard, InsertIntoDesc insertIntoDesc, StreamTypeService typeService, EventAdapterService eventAdapterService) throws ExprValidationException {
        if (isUsingWildcard && insertIntoDesc != null && !insertIntoDesc.getColumnNames().isEmpty()) {
            throw new ExprValidationException("Wildcard not allowed when insert-into specifies column order");
        }
        if (selectionList.isEmpty() && selectedStreams.isEmpty()) {
            if (typeService.getStreamNames().length > 1) {
                log.debug(".getProcessor Using SelectExprJoinWildcardProcessor");
                return new SelectExprJoinWildcardProcessor(typeService.getStreamNames(), typeService.getEventTypes(), eventAdapterService, insertIntoDesc);
            }
            if (insertIntoDesc == null) {
                log.debug(".getProcessor Using no select expr processor");
                return null;
            }
        }
        SelectExprProcessorFactory.verifyNameUniqueness(selectionList, selectedStreams);
        log.debug(".getProcessor Using SelectExprEvalProcessor");
        if (selectedStreams.size() == 0) {
            return new SelectExprEvalProcessor(selectionList, insertIntoDesc, isUsingWildcard, typeService, eventAdapterService);
        }
        return new SelectExprEvalProcessorStreams(selectionList, selectedStreams, insertIntoDesc, isUsingWildcard, typeService, eventAdapterService);
    }

    protected static void verifyNameUniqueness(List<SelectExprElementCompiledSpec> selectionList, List<SelectExprElementStreamCompiledSpec> selectedStreams) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (SelectExprElementCompiledSpec selectExprElementCompiledSpec : selectionList) {
            if (names.contains(selectExprElementCompiledSpec.getAssignedName())) {
                throw new ExprValidationException("Property alias name '" + selectExprElementCompiledSpec.getAssignedName() + "' appears more then once in select clause");
            }
            names.add(selectExprElementCompiledSpec.getAssignedName());
        }
        for (SelectExprElementStreamCompiledSpec selectExprElementStreamCompiledSpec : selectedStreams) {
            if (selectExprElementStreamCompiledSpec.getOptionalAliasName() == null) continue;
            if (names.contains(selectExprElementStreamCompiledSpec.getOptionalAliasName())) {
                throw new ExprValidationException("Property alias name '" + selectExprElementStreamCompiledSpec.getOptionalAliasName() + "' appears more then once in select clause");
            }
            names.add(selectExprElementStreamCompiledSpec.getOptionalAliasName());
        }
    }
}

