/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.core;

import java.util.LinkedHashMap;
import java.util.Map;
import net.esper.eql.core.DuplicatePropertyException;
import net.esper.eql.core.PropertyNotFoundException;
import net.esper.eql.core.PropertyResolutionDescriptor;
import net.esper.eql.core.StreamNotFoundException;
import net.esper.eql.core.StreamTypeService;
import net.esper.event.EventType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamTypeServiceImpl
implements StreamTypeService {
    private final EventType[] eventTypes;
    private final String[] streamNames;
    private boolean isStreamZeroUnambigous;
    private boolean requireStreamNames;

    public StreamTypeServiceImpl(EventType[] eventTypes, String[] streamNames) {
        this.eventTypes = eventTypes;
        this.streamNames = streamNames;
        if (eventTypes.length != streamNames.length) {
            throw new IllegalArgumentException("Number of entries for event types and stream names differs");
        }
    }

    public StreamTypeServiceImpl(LinkedHashMap<String, EventType> namesAndTypes, boolean isStreamZeroUnambigous, boolean requireStreamNames) {
        this.isStreamZeroUnambigous = isStreamZeroUnambigous;
        this.requireStreamNames = requireStreamNames;
        this.eventTypes = new EventType[namesAndTypes.size()];
        this.streamNames = new String[namesAndTypes.size()];
        int count = 0;
        for (Map.Entry<String, EventType> entry : namesAndTypes.entrySet()) {
            this.streamNames[count] = entry.getKey();
            this.eventTypes[count] = entry.getValue();
            ++count;
        }
    }

    @Override
    public EventType[] getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public String[] getStreamNames() {
        return this.streamNames;
    }

    @Override
    public PropertyResolutionDescriptor resolveByPropertyName(String propertyName) throws DuplicatePropertyException, PropertyNotFoundException {
        if (propertyName == null) {
            throw new IllegalArgumentException("Null property name");
        }
        PropertyResolutionDescriptor desc = this.findByPropertyName(propertyName);
        if (this.requireStreamNames && desc.getStreamNum() != 0) {
            throw new PropertyNotFoundException("Property named '" + propertyName + "' must be prefixed by a stream name, use the as-clause to name the stream");
        }
        return desc;
    }

    @Override
    public PropertyResolutionDescriptor resolveByStreamAndPropName(String streamName, String propertyName) throws PropertyNotFoundException, StreamNotFoundException {
        if (streamName == null) {
            throw new IllegalArgumentException("Null property name");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Null property name");
        }
        return this.findByStreamName(propertyName, streamName);
    }

    @Override
    public PropertyResolutionDescriptor resolveByStreamAndPropName(String streamAndPropertyName) throws DuplicatePropertyException, PropertyNotFoundException {
        if (streamAndPropertyName == null) {
            throw new IllegalArgumentException("Null stream and property name");
        }
        PropertyResolutionDescriptor desc = null;
        try {
            desc = this.findByPropertyName(streamAndPropertyName);
        }
        catch (PropertyNotFoundException ex) {
            int index = streamAndPropertyName.indexOf(46);
            if (index == -1) {
                throw ex;
            }
            String streamName = streamAndPropertyName.substring(0, index);
            String propertyName = streamAndPropertyName.substring(index + 1, streamAndPropertyName.length());
            try {
                desc = this.findByStreamName(propertyName, streamName);
            }
            catch (StreamNotFoundException e) {
                throw ex;
            }
            return desc;
        }
        return desc;
    }

    private PropertyResolutionDescriptor findByPropertyName(String propertyName) throws DuplicatePropertyException, PropertyNotFoundException {
        int index = 0;
        int foundIndex = 0;
        int foundCount = 0;
        EventType streamType = null;
        for (int i = 0; i < this.eventTypes.length; ++i) {
            if (this.eventTypes[i].isProperty(propertyName)) {
                streamType = this.eventTypes[i];
                ++foundCount;
                foundIndex = index;
                if (i == 0 && this.isStreamZeroUnambigous) {
                    return new PropertyResolutionDescriptor(this.streamNames[0], this.eventTypes[0], propertyName, 0, streamType.getPropertyType(propertyName));
                }
            }
            ++index;
        }
        if (foundCount > 1) {
            throw new DuplicatePropertyException("Property named '" + propertyName + "' is ambigous as is valid for more then one stream");
        }
        if (streamType == null) {
            throw new PropertyNotFoundException("Property named '" + propertyName + "' is not valid in any stream");
        }
        return new PropertyResolutionDescriptor(this.streamNames[foundIndex], this.eventTypes[foundIndex], propertyName, foundIndex, streamType.getPropertyType(propertyName));
    }

    private PropertyResolutionDescriptor findByStreamName(String propertyName, String streamName) throws PropertyNotFoundException, StreamNotFoundException {
        int index = 0;
        EventType streamType = null;
        for (int i = 0; i < this.eventTypes.length; ++i) {
            if (this.streamNames[i] != null && this.streamNames[i].equals(streamName)) {
                streamType = this.eventTypes[i];
                break;
            }
            ++index;
        }
        if (streamType == null) {
            throw new StreamNotFoundException("Stream named " + streamName + " is not defined");
        }
        Class propertyType = streamType.getPropertyType(propertyName);
        if (propertyType == null) {
            throw new PropertyNotFoundException("Property named '" + propertyName + "' is not valid in stream " + streamName);
        }
        return new PropertyResolutionDescriptor(streamName, streamType, propertyName, index, propertyType);
    }
}

