/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.esper.client.EPException;
import net.esper.collection.Pair;
import net.esper.eql.db.DatabaseConfigException;
import net.esper.eql.db.DatabaseConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionCache {
    private DatabaseConnectionFactory databaseConnectionFactory;
    private String sql;
    private static Log log = LogFactory.getLog(ConnectionCache.class);

    public abstract Pair<Connection, PreparedStatement> getConnection();

    public abstract void doneWith(Pair<Connection, PreparedStatement> var1);

    public abstract void destroy();

    protected ConnectionCache(DatabaseConnectionFactory databaseConnectionFactory, String sql) {
        this.databaseConnectionFactory = databaseConnectionFactory;
        this.sql = sql;
    }

    protected static void close(Pair<Connection, PreparedStatement> pair) {
        log.info(".close Closing statement and connection");
        try {
            pair.getSecond().close();
        }
        catch (SQLException ex) {
            try {
                pair.getFirst().close();
            }
            catch (SQLException e) {
                log.error("Error closing JDBC connection:" + e.getMessage(), e);
            }
            throw new EPException("Error closing statement", ex);
        }
        try {
            pair.getFirst().close();
        }
        catch (SQLException ex) {
            throw new EPException("Error closing statement", ex);
        }
    }

    protected Pair<Connection, PreparedStatement> makeNew() {
        log.info(".makeNew Obtaining new connection and statement");
        Connection connection = null;
        try {
            connection = this.databaseConnectionFactory.getConnection();
        }
        catch (DatabaseConfigException ex) {
            throw new EPException("Error obtaining connection", ex);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.sql);
        }
        catch (SQLException ex) {
            throw new EPException("Error preparing statement '" + this.sql + '\'', ex);
        }
        return new Pair<Connection, PreparedStatement>(connection, preparedStatement);
    }
}

