/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.esper.client.ConfigurationDBRef;
import net.esper.collection.MultiKey;
import net.esper.collection.apachecommons.ReferenceMap;
import net.esper.core.EPStatementHandle;
import net.esper.core.EPStatementHandleCallback;
import net.esper.core.ExtensionServicesContext;
import net.esper.eql.db.DataCache;
import net.esper.eql.join.table.EventTable;
import net.esper.schedule.ScheduleHandle;
import net.esper.schedule.ScheduleHandleCallback;
import net.esper.schedule.ScheduleSlot;
import net.esper.schedule.SchedulingService;

public class DataCacheExpiringImpl
implements DataCache,
ScheduleHandleCallback {
    private final long maxAgeMSec;
    private final long purgeIntervalMSec;
    private final SchedulingService schedulingService;
    private final ScheduleSlot scheduleSlot;
    private final Map<MultiKey<Object>, Item> cache;
    private final EPStatementHandle epStatementHandle;
    private boolean isScheduled;

    public DataCacheExpiringImpl(double maxAgeSec, double purgeIntervalSec, ConfigurationDBRef.CacheReferenceType cacheReferenceType, SchedulingService schedulingService, ScheduleSlot scheduleSlot, EPStatementHandle epStatementHandle) {
        this.maxAgeMSec = (long)maxAgeSec * 1000L;
        this.purgeIntervalMSec = (long)purgeIntervalSec * 1000L;
        this.schedulingService = schedulingService;
        this.scheduleSlot = scheduleSlot;
        this.cache = cacheReferenceType == ConfigurationDBRef.CacheReferenceType.HARD ? new HashMap<MultiKey<Object>, Item>() : (cacheReferenceType == ConfigurationDBRef.CacheReferenceType.SOFT ? new ReferenceMap(1, 1) : new WeakHashMap<MultiKey<Object>, Item>());
        this.epStatementHandle = epStatementHandle;
    }

    public EventTable getCached(Object[] lookupKeys) {
        MultiKey<Object> key = new MultiKey<Object>(lookupKeys);
        Item item = this.cache.get(key);
        if (item == null) {
            return null;
        }
        long now = this.schedulingService.getTime();
        if (now - item.getTime() > this.maxAgeMSec) {
            this.cache.remove(key);
            return null;
        }
        return item.getData();
    }

    public void put(Object[] lookupKeys, EventTable rows) {
        MultiKey<Object> key = new MultiKey<Object>(lookupKeys);
        long now = this.schedulingService.getTime();
        Item item = new Item(rows, now);
        this.cache.put(key, item);
        if (!this.isScheduled) {
            EPStatementHandleCallback callback = new EPStatementHandleCallback(this.epStatementHandle, this);
            this.schedulingService.add(this.purgeIntervalMSec, (ScheduleHandle)callback, this.scheduleSlot);
            this.isScheduled = true;
        }
    }

    protected long getMaxAgeMSec() {
        return this.maxAgeMSec;
    }

    protected long getPurgeIntervalMSec() {
        return this.purgeIntervalMSec;
    }

    public boolean isActive() {
        return true;
    }

    protected long getSize() {
        return this.cache.size();
    }

    public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
        long now = this.schedulingService.getTime();
        Iterator<MultiKey<Object>> it = this.cache.keySet().iterator();
        while (it.hasNext()) {
            Item item = this.cache.get(it.next());
            if (now - item.getTime() <= this.maxAgeMSec) continue;
            it.remove();
        }
        this.isScheduled = false;
    }

    private static class Item {
        private EventTable data;
        private long time;

        public Item(EventTable data, long time) {
            this.data = data;
            this.time = time;
        }

        public EventTable getData() {
            return this.data;
        }

        public long getTime() {
            return this.time;
        }
    }
}

