/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import net.esper.client.ConfigurationDBRef;
import net.esper.core.EPStatementHandle;
import net.esper.eql.db.DataCache;
import net.esper.eql.db.DataCacheExpiringImpl;
import net.esper.eql.db.DataCacheLRUImpl;
import net.esper.eql.db.DataCacheNullImpl;
import net.esper.schedule.ScheduleBucket;
import net.esper.schedule.SchedulingService;

public class DataCacheFactory {
    public static DataCache getDataCache(ConfigurationDBRef.DataCacheDesc cacheDesc, EPStatementHandle epStatementHandle, SchedulingService schedulingService, ScheduleBucket scheduleBucket) {
        if (cacheDesc == null) {
            return new DataCacheNullImpl();
        }
        if (cacheDesc instanceof ConfigurationDBRef.LRUCacheDesc) {
            ConfigurationDBRef.LRUCacheDesc lruCache = (ConfigurationDBRef.LRUCacheDesc)cacheDesc;
            return new DataCacheLRUImpl(lruCache.getSize());
        }
        if (cacheDesc instanceof ConfigurationDBRef.ExpiryTimeCacheDesc) {
            ConfigurationDBRef.ExpiryTimeCacheDesc expCache = (ConfigurationDBRef.ExpiryTimeCacheDesc)cacheDesc;
            return new DataCacheExpiringImpl(expCache.getMaxAgeSeconds(), expCache.getPurgeIntervalSeconds(), expCache.getCacheReferenceType(), schedulingService, scheduleBucket.allocateSlot(), epStatementHandle);
        }
        throw new IllegalStateException("Cache implementation class not configured");
    }
}

