/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import java.util.HashMap;
import java.util.Map;
import net.esper.client.ConfigurationDBRef;
import net.esper.core.EPStatementHandle;
import net.esper.eql.db.ColumnSettings;
import net.esper.eql.db.ConnectionCache;
import net.esper.eql.db.ConnectionCacheImpl;
import net.esper.eql.db.ConnectionNoCacheImpl;
import net.esper.eql.db.DataCache;
import net.esper.eql.db.DataCacheFactory;
import net.esper.eql.db.DatabaseConfigException;
import net.esper.eql.db.DatabaseConfigService;
import net.esper.eql.db.DatabaseConnectionFactory;
import net.esper.eql.db.DatabaseDMConnFactory;
import net.esper.eql.db.DatabaseDSConnFactory;
import net.esper.schedule.ScheduleBucket;
import net.esper.schedule.SchedulingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConfigServiceImpl
implements DatabaseConfigService {
    private final Map<String, ConfigurationDBRef> mapDatabaseRef;
    private final Map<String, DatabaseConnectionFactory> connectionFactories;
    private final SchedulingService schedulingService;
    private final ScheduleBucket scheduleBucket;

    public DatabaseConfigServiceImpl(Map<String, ConfigurationDBRef> mapDatabaseRef, SchedulingService schedulingService, ScheduleBucket scheduleBucket) {
        this.mapDatabaseRef = mapDatabaseRef;
        this.connectionFactories = new HashMap<String, DatabaseConnectionFactory>();
        this.schedulingService = schedulingService;
        this.scheduleBucket = scheduleBucket;
    }

    @Override
    public ConnectionCache getConnectionCache(String databaseName, String preparedStatementText) throws DatabaseConfigException {
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        DatabaseConnectionFactory connectionFactory = this.getConnectionFactory(databaseName);
        boolean retain = config.getConnectionLifecycleEnum().equals((Object)ConfigurationDBRef.ConnectionLifecycleEnum.RETAIN);
        if (retain) {
            return new ConnectionCacheImpl(connectionFactory, preparedStatementText);
        }
        return new ConnectionNoCacheImpl(connectionFactory, preparedStatementText);
    }

    @Override
    public DatabaseConnectionFactory getConnectionFactory(String databaseName) throws DatabaseConfigException {
        DatabaseConnectionFactory factory = this.connectionFactories.get(databaseName);
        if (factory != null) {
            return factory;
        }
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        ConfigurationDBRef.ConnectionSettings settings = config.getConnectionSettings();
        if (config.getConnectionFactoryDesc() instanceof ConfigurationDBRef.DriverManagerConnection) {
            ConfigurationDBRef.DriverManagerConnection dmConfig = (ConfigurationDBRef.DriverManagerConnection)config.getConnectionFactoryDesc();
            factory = new DatabaseDMConnFactory(dmConfig, settings);
        } else {
            ConfigurationDBRef.DataSourceConnection dsConfig = (ConfigurationDBRef.DataSourceConnection)config.getConnectionFactoryDesc();
            factory = new DatabaseDSConnFactory(dsConfig, settings);
        }
        this.connectionFactories.put(databaseName, factory);
        return factory;
    }

    @Override
    public DataCache getDataCache(String databaseName, EPStatementHandle epStatementHandle) throws DatabaseConfigException {
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        ConfigurationDBRef.DataCacheDesc dataCacheDesc = config.getDataCacheDesc();
        return DataCacheFactory.getDataCache(dataCacheDesc, epStatementHandle, this.schedulingService, this.scheduleBucket);
    }

    @Override
    public ColumnSettings getQuerySetting(String databaseName) throws DatabaseConfigException {
        ConfigurationDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + '\'');
        }
        return new ColumnSettings(config.getMetadataRetrievalEnum(), config.getColumnChangeCase(), config.getJavaSqlTypesMapping());
    }
}

