/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.esper.client.ConfigurationDBRef;
import net.esper.eql.db.DatabaseConfigException;
import net.esper.eql.db.DatabaseConnectionFactory;
import net.esper.eql.db.DatabaseDMConnFactory;

public class DatabaseDSConnFactory
implements DatabaseConnectionFactory {
    private final ConfigurationDBRef.DataSourceConnection dsConfig;
    private final ConfigurationDBRef.ConnectionSettings connectionSettings;

    public DatabaseDSConnFactory(ConfigurationDBRef.DataSourceConnection dsConfig, ConfigurationDBRef.ConnectionSettings connectionSettings) {
        this.dsConfig = dsConfig;
        this.connectionSettings = connectionSettings;
    }

    public Connection getConnection() throws DatabaseConfigException {
        Properties envProps = this.dsConfig.getEnvProperties();
        if (envProps == null) {
            envProps = new Properties();
        }
        InitialContext ctx = null;
        try {
            ctx = !envProps.isEmpty() ? new InitialContext(envProps) : new InitialContext();
        }
        catch (NamingException ex) {
            throw new DatabaseConfigException("Error instantiating initial context", ex);
        }
        DataSource ds = null;
        String lookupName = this.dsConfig.getContextLookupName();
        try {
            ds = (DataSource)ctx.lookup(lookupName);
        }
        catch (NamingException ex) {
            throw new DatabaseConfigException("Error looking up data source in context using name '" + lookupName + '\'', ex);
        }
        if (ds == null) {
            throw new DatabaseConfigException("Null data source obtained through context using name '" + lookupName + '\'');
        }
        Connection connection = null;
        try {
            connection = ds.getConnection();
        }
        catch (SQLException ex) {
            String detail = "SQLException: " + ex.getMessage() + " SQLState: " + ex.getSQLState() + " VendorError: " + ex.getErrorCode();
            throw new DatabaseConfigException("Error obtaining database connection using datasource with detail " + detail, ex);
        }
        DatabaseDMConnFactory.setConnectionOptions(connection, this.connectionSettings);
        return connection;
    }
}

