/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.esper.client.EPException;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.PropertyResolutionDescriptor;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.StreamTypesException;
import net.esper.eql.db.DataCache;
import net.esper.eql.db.PollExecStrategy;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.join.PollResultIndexingStrategy;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.EventType;
import net.esper.schedule.TimeProvider;
import net.esper.view.HistoricalEventViewable;
import net.esper.view.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabasePollingViewable
implements HistoricalEventViewable {
    private final int myStreamNumber;
    private final PollExecStrategy pollExecStrategy;
    private final List<String> inputParameters;
    private final DataCache dataCache;
    private final EventType eventType;
    private EventPropertyGetter[] getters;
    private int[] getterStreamNumbers;

    public DatabasePollingViewable(int myStreamNumber, List<String> inputParameters, PollExecStrategy pollExecStrategy, DataCache dataCache, EventType eventType) {
        this.myStreamNumber = myStreamNumber;
        this.inputParameters = inputParameters;
        this.pollExecStrategy = pollExecStrategy;
        this.dataCache = dataCache;
        this.eventType = eventType;
    }

    @Override
    public void stop() {
        this.pollExecStrategy.destroy();
    }

    @Override
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        this.getters = new EventPropertyGetter[this.inputParameters.size()];
        this.getterStreamNumbers = new int[this.inputParameters.size()];
        int count = 0;
        for (String inputParam : this.inputParameters) {
            PropertyResolutionDescriptor desc = null;
            try {
                desc = streamTypeService.resolveByStreamAndPropName(inputParam);
            }
            catch (StreamTypesException ex) {
                throw new ExprValidationException("Property '" + inputParam + "' failed to resolve, reason: " + ex.getMessage());
            }
            int streamId = desc.getStreamNum();
            if (streamId == this.myStreamNumber) {
                throw new ExprValidationException("Invalid property '" + inputParam + "' resolves to the historical data itself");
            }
            String propName = desc.getPropertyName();
            this.getters[count] = streamTypeService.getEventTypes()[streamId].getGetter(propName);
            this.getterStreamNumbers[count] = streamId;
            ++count;
        }
    }

    @Override
    public EventTable[] poll(EventBean[][] lookupEventsPerStream, PollResultIndexingStrategy indexingStrategy) {
        this.pollExecStrategy.start();
        EventTable[] resultPerInputRow = new EventTable[lookupEventsPerStream.length];
        for (int row = 0; row < lookupEventsPerStream.length; ++row) {
            Object[] lookupValues = new Object[this.inputParameters.size()];
            for (int valueNum = 0; valueNum < this.inputParameters.size(); ++valueNum) {
                Object lookupValue;
                int streamNum = this.getterStreamNumbers[valueNum];
                EventBean streamEvent = lookupEventsPerStream[row][streamNum];
                lookupValues[valueNum] = lookupValue = this.getters[valueNum].get(streamEvent);
            }
            EventTable result = this.dataCache.getCached(lookupValues);
            if (result != null) {
                resultPerInputRow[row] = result;
                continue;
            }
            try {
                EventTable indexTable;
                List<EventBean> pollResult = this.pollExecStrategy.poll(lookupValues);
                resultPerInputRow[row] = indexTable = indexingStrategy.index(pollResult, this.dataCache.isActive());
                this.dataCache.put(lookupValues, indexTable);
                continue;
            }
            catch (EPException ex) {
                this.pollExecStrategy.done();
                throw ex;
            }
        }
        this.pollExecStrategy.done();
        return resultPerInputRow;
    }

    @Override
    public View addView(View view) {
        return view;
    }

    @Override
    public List<View> getViews() {
        return new LinkedList<View>();
    }

    @Override
    public boolean removeView(View view) {
        throw new UnsupportedOperationException("Subviews not supported");
    }

    @Override
    public boolean hasViews() {
        return false;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Iterator not supported");
    }
}

