/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import antlr.Token;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.client.ConfigurationDBRef;
import net.esper.core.EPStatementHandle;
import net.esper.eql.db.ColumnSettings;
import net.esper.eql.db.ConnectionCache;
import net.esper.eql.db.DBOutputTypeDesc;
import net.esper.eql.db.DataCache;
import net.esper.eql.db.DatabaseConfigException;
import net.esper.eql.db.DatabaseConfigService;
import net.esper.eql.db.DatabaseConnectionFactory;
import net.esper.eql.db.DatabasePollingViewable;
import net.esper.eql.db.PollExecStrategyDBQuery;
import net.esper.eql.db.QueryMetaData;
import net.esper.eql.db.SQLParameterDesc;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.generated.EQLStatementLexer;
import net.esper.eql.spec.DBStatementStreamSpec;
import net.esper.event.EventAdapterService;
import net.esper.event.EventType;
import net.esper.util.DatabaseTypeBinding;
import net.esper.util.DatabaseTypeEnum;
import net.esper.util.PlaceholderParseException;
import net.esper.util.PlaceholderParser;
import net.esper.util.SQLTypeMapUtil;
import net.esper.view.HistoricalEventViewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabasePollingViewableFactory {
    private static final String SAMPLE_WHERECLAUSE_PLACEHOLDER = "$ESPER-SAMPLE-WHERE";
    private static final Log log = LogFactory.getLog(DatabasePollingViewableFactory.class);

    public static HistoricalEventViewable createDBStatementView(int streamNumber, DBStatementStreamSpec databaseStreamSpec, DatabaseConfigService databaseConfigService, EventAdapterService eventAdapterService, EPStatementHandle epStatementHandle) throws ExprValidationException {
        DataCache dataCache;
        ConnectionCache connectionCache;
        QueryMetaData queryMetaData;
        String connectionClass;
        List<PlaceholderParser.Fragment> sqlFragments = null;
        try {
            sqlFragments = PlaceholderParser.parsePlaceholder(databaseStreamSpec.getSqlWithSubsParams());
        }
        catch (PlaceholderParseException ex) {
            String text = "Error parsing SQL";
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        String preparedStatementText = DatabasePollingViewableFactory.createPreparedStatement(sqlFragments);
        SQLParameterDesc parameterDesc = DatabasePollingViewableFactory.getParameters(sqlFragments);
        if (log.isDebugEnabled()) {
            log.debug(".createDBEventStream preparedStatementText=" + preparedStatementText + " parameterDesc=" + parameterDesc);
        }
        String databaseName = databaseStreamSpec.getDatabaseName();
        DatabaseConnectionFactory databaseConnectionFactory = null;
        ColumnSettings metadataSetting = null;
        try {
            databaseConnectionFactory = databaseConfigService.getConnectionFactory(databaseName);
            metadataSetting = databaseConfigService.getQuerySetting(databaseName);
        }
        catch (DatabaseConfigException ex) {
            String text = "Error connecting to database '" + databaseName + '\'';
            log.error(text, ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        Connection connection = null;
        try {
            connection = databaseConnectionFactory.getConnection();
        }
        catch (DatabaseConfigException ex) {
            String text = "Error connecting to database '" + databaseName + '\'';
            log.error(text, ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        ConfigurationDBRef.MetadataOriginEnum metaOriginPolicy = metadataSetting.getMetadataRetrievalEnum();
        if (metaOriginPolicy == ConfigurationDBRef.MetadataOriginEnum.DEFAULT && (connectionClass = connection.getClass().getName()).toLowerCase().contains("oracle")) {
            metaOriginPolicy = ConfigurationDBRef.MetadataOriginEnum.SAMPLE;
        }
        try {
            if (metaOriginPolicy == ConfigurationDBRef.MetadataOriginEnum.METADATA || metaOriginPolicy == ConfigurationDBRef.MetadataOriginEnum.DEFAULT) {
                queryMetaData = DatabasePollingViewableFactory.getPreparedStmtMetadata(connection, parameterDesc.getParameters(), preparedStatementText, metadataSetting);
            } else {
                String sampleSQL;
                boolean isGivenMetadataSQL = true;
                if (databaseStreamSpec.getMetadataSQL() != null) {
                    sampleSQL = databaseStreamSpec.getMetadataSQL();
                    isGivenMetadataSQL = true;
                    if (log.isInfoEnabled()) {
                        log.info(".createDBStatementView Using provided sample SQL '" + sampleSQL + "'");
                    }
                } else {
                    sampleSQL = DatabasePollingViewableFactory.createSamplePlaceholderStatement(sqlFragments);
                    if (log.isInfoEnabled()) {
                        log.info(".createDBStatementView Using un-lexed sample SQL '" + sampleSQL + "'");
                    }
                    if (parameterDesc.getBuiltinIdentifiers().length != 1) {
                        sampleSQL = DatabasePollingViewableFactory.lexSampleSQL(sampleSQL);
                        if (log.isInfoEnabled()) {
                            log.info(".createDBStatementView Using lexed sample SQL '" + sampleSQL + "'");
                        }
                    }
                }
                queryMetaData = DatabasePollingViewableFactory.getExampleQueryMetaData(connection, parameterDesc.getParameters(), sampleSQL, metadataSetting, isGivenMetadataSQL);
            }
        }
        catch (ExprValidationException ex) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw ex;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            String text = "Error closing connection";
            log.error(text, e);
            throw new ExprValidationException(text + ", reason: " + e.getMessage());
        }
        HashMap<String, Class> eventTypeFields = new HashMap<String, Class>();
        for (Map.Entry<String, DBOutputTypeDesc> entry : queryMetaData.getOutputParameters().entrySet()) {
            String name = entry.getKey();
            DBOutputTypeDesc dbOutputDesc = entry.getValue();
            Class clazz = dbOutputDesc.getOptionalBinding() != null ? dbOutputDesc.getOptionalBinding().getType() : SQLTypeMapUtil.sqlTypeToClass(dbOutputDesc.getSqlType(), dbOutputDesc.getClassName());
            eventTypeFields.put(name, clazz);
        }
        EventType eventType = eventAdapterService.createAnonymousMapType(eventTypeFields);
        try {
            connectionCache = databaseConfigService.getConnectionCache(databaseName, preparedStatementText);
            dataCache = databaseConfigService.getDataCache(databaseName, epStatementHandle);
        }
        catch (DatabaseConfigException e) {
            String text = "Error obtaining cache configuration";
            log.error(text, e);
            throw new ExprValidationException(text + ", reason: " + e.getMessage());
        }
        PollExecStrategyDBQuery dbPollStrategy = new PollExecStrategyDBQuery(eventAdapterService, eventType, connectionCache, preparedStatementText, queryMetaData.getOutputParameters());
        return new DatabasePollingViewable(streamNumber, queryMetaData.getInputParameters(), dbPollStrategy, dataCache, eventType);
    }

    private static QueryMetaData getExampleQueryMetaData(Connection connection, String[] parameters, String sampleSQL, ColumnSettings metadataSetting, boolean isUsingMetadataSQL) throws ExprValidationException {
        Map<String, DBOutputTypeDesc> outputProperties;
        ResultSet result;
        Statement statement;
        LinkedList<String> inputParameters = new LinkedList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            inputParameters.add(parameters[i]);
        }
        try {
            statement = connection.createStatement();
        }
        catch (SQLException ex) {
            String text = "Error creating statement";
            log.error(text, ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        try {
            result = statement.executeQuery(sampleSQL);
        }
        catch (SQLException ex) {
            String text = isUsingMetadataSQL ? "Error compiling metadata SQL to retrieve statement metadata, using sql text '" + sampleSQL + "'" : "Error compiling metadata SQL to retrieve statement metadata, consider using the 'metadatasql' syntax, using sql text '" + sampleSQL + "'";
            log.error(text, ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        try {
            outputProperties = DatabasePollingViewableFactory.compileResultMetaData(result.getMetaData(), metadataSetting);
        }
        catch (SQLException ex) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            String text = "Error in statement '" + sampleSQL + "', failed to obtain result metadata";
            log.error(text, ex);
            throw new ExprValidationException(text + ", please check the statement, reason: " + ex.getMessage());
        }
        return new QueryMetaData(inputParameters, outputProperties);
    }

    protected static String lexSampleSQL(String querySQL) throws ExprValidationException {
        StringWriter changedSQL;
        StringReader reader = new StringReader(querySQL);
        EQLStatementLexer lexer2 = new EQLStatementLexer(reader);
        int whereIndex = -1;
        int groupbyIndex = -1;
        int havingIndex = -1;
        int orderByIndex = -1;
        ArrayList<Integer> unionIndexes = new ArrayList<Integer>();
        while (true) {
            try {
                Token token2;
                while ((token2 = lexer2.nextToken()) != null && token2.getText() != null) {
                    if (token2.getText().trim().equals("where")) {
                        whereIndex = token2.getColumn();
                    }
                    if (token2.getText().trim().equals("group")) {
                        groupbyIndex = token2.getColumn();
                    }
                    if (token2.getText().trim().equals("having")) {
                        havingIndex = token2.getColumn();
                    }
                    if (token2.getText().trim().equals("order")) {
                        orderByIndex = token2.getColumn();
                    }
                    if (!token2.getText().trim().equals("union")) continue;
                    unionIndexes.add(token2.getColumn());
                }
            }
            catch (TokenStreamException e) {
                log.warn("Error parsing string '" + querySQL + "' for analysis :" + e.getMessage(), e);
                continue;
            }
            break;
        }
        if (unionIndexes.size() != 0) {
            changedSQL = new StringWriter();
            int lastIndex = 0;
            for (int i = 0; i < unionIndexes.size(); ++i) {
                int index = (Integer)unionIndexes.get(i);
                String fragment = i > 0 ? querySQL.substring(lastIndex + 5, index - 1) : querySQL.substring(lastIndex, index - 1);
                String lexedFragment = DatabasePollingViewableFactory.lexSampleSQL(fragment);
                if (i > 0) {
                    changedSQL.append("union ");
                }
                changedSQL.append(lexedFragment);
                lastIndex = index - 1;
            }
            String fragment = querySQL.substring(lastIndex + 5, querySQL.length());
            String lexedFragment = DatabasePollingViewableFactory.lexSampleSQL(fragment);
            changedSQL.append("union ");
            changedSQL.append(lexedFragment);
            return changedSQL.toString();
        }
        if (whereIndex != -1) {
            changedSQL = new StringWriter();
            String prefix = querySQL.substring(0, whereIndex + 5);
            String suffix = querySQL.substring(whereIndex + 5, querySQL.length());
            changedSQL.write(prefix);
            changedSQL.write("1=0 and ");
            changedSQL.write(suffix);
            return changedSQL.toString();
        }
        int insertIndex = -1;
        if (groupbyIndex != -1) {
            insertIndex = groupbyIndex;
        } else if (havingIndex != -1) {
            insertIndex = havingIndex;
        } else if (orderByIndex != -1) {
            insertIndex = orderByIndex;
        } else {
            StringWriter changedSQL2 = new StringWriter();
            changedSQL2.write(querySQL);
            changedSQL2.write(" where 1=0 ");
            return changedSQL2.toString();
        }
        try {
            StringWriter changedSQL3 = new StringWriter();
            String prefix = querySQL.substring(0, insertIndex - 1);
            changedSQL3.write(prefix);
            changedSQL3.write("where 1=0 ");
            String suffix = querySQL.substring(insertIndex - 1, querySQL.length());
            changedSQL3.write(suffix);
            return changedSQL3.toString();
        }
        catch (Exception ex) {
            String text = "Error constructing sample SQL to retrieve metadata for JDBC-drivers that don't support metadata, consider using the $ESPER-SAMPLE-WHERE placeholder or providing a sample SQL";
            log.error(text, ex);
            throw new ExprValidationException(text, ex);
        }
    }

    private static QueryMetaData getPreparedStmtMetadata(Connection connection, String[] parameters, String preparedStatementText, ColumnSettings metadataSetting) throws ExprValidationException {
        Map<String, DBOutputTypeDesc> outputProperties;
        PreparedStatement prepared;
        try {
            if (log.isInfoEnabled()) {
                log.info(".getPreparedStmtMetadata Preparing statement '" + preparedStatementText + "'");
            }
            prepared = connection.prepareStatement(preparedStatementText);
        }
        catch (SQLException ex) {
            String text = "Error preparing statement '" + preparedStatementText + '\'';
            log.error(text, ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        LinkedList<String> inputParameters = new LinkedList<String>();
        try {
            ParameterMetaData parameterMetaData = prepared.getParameterMetaData();
            for (int i = 0; i < parameterMetaData.getParameterCount(); ++i) {
                inputParameters.add(parameters[i]);
            }
        }
        catch (Exception ex) {
            try {
                prepared.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            String text = "Error obtaining parameter metadata from prepared statement, consider turning off metadata interrogation via configuration, for statement '" + preparedStatementText + '\'';
            log.error(text, ex);
            throw new ExprValidationException(text + ", please check the statement, reason: " + ex.getMessage());
        }
        try {
            outputProperties = DatabasePollingViewableFactory.compileResultMetaData(prepared.getMetaData(), metadataSetting);
        }
        catch (SQLException ex) {
            try {
                prepared.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            String text = "Error in statement '" + preparedStatementText + "', failed to obtain result metadata, consider turning off metadata interrogation via configuration";
            log.error(text, ex);
            throw new ExprValidationException(text + ", please check the statement, reason: " + ex.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug(".createDBEventStream in=" + ((Object)inputParameters).toString() + " out=" + outputProperties.toString());
        }
        try {
            prepared.close();
        }
        catch (SQLException e) {
            String text = "Error closing prepared statement";
            log.error(text, e);
            throw new ExprValidationException(text + ", reason: " + e.getMessage());
        }
        return new QueryMetaData(inputParameters, outputProperties);
    }

    private static String createPreparedStatement(List<PlaceholderParser.Fragment> parseFragements) {
        StringBuilder buffer = new StringBuilder();
        for (PlaceholderParser.Fragment fragment : parseFragements) {
            if (!fragment.isParameter()) {
                buffer.append(fragment.getValue());
                continue;
            }
            if (fragment.getValue().equals(SAMPLE_WHERECLAUSE_PLACEHOLDER)) continue;
            buffer.append('?');
        }
        return buffer.toString();
    }

    private static String createSamplePlaceholderStatement(List<PlaceholderParser.Fragment> parseFragements) {
        StringBuilder buffer = new StringBuilder();
        for (PlaceholderParser.Fragment fragment : parseFragements) {
            if (!fragment.isParameter()) {
                buffer.append(fragment.getValue());
                continue;
            }
            if (fragment.getValue().equals(SAMPLE_WHERECLAUSE_PLACEHOLDER)) {
                buffer.append(" where 1=0 ");
                break;
            }
            buffer.append("null");
        }
        return buffer.toString();
    }

    private static SQLParameterDesc getParameters(List<PlaceholderParser.Fragment> parseFragements) {
        LinkedList<String> eventPropertyParams = new LinkedList<String>();
        LinkedList<String> builtinParams = new LinkedList<String>();
        for (PlaceholderParser.Fragment fragment : parseFragements) {
            if (!fragment.isParameter()) continue;
            if (fragment.getValue().equals(SAMPLE_WHERECLAUSE_PLACEHOLDER)) {
                builtinParams.add(fragment.getValue());
                continue;
            }
            eventPropertyParams.add(fragment.getValue());
        }
        String[] params = eventPropertyParams.toArray(new String[0]);
        String[] builtin = eventPropertyParams.toArray(new String[0]);
        return new SQLParameterDesc(params, builtin);
    }

    private static Map<String, DBOutputTypeDesc> compileResultMetaData(ResultSetMetaData resultMetaData, ColumnSettings columnSettings) throws SQLException {
        HashMap<String, DBOutputTypeDesc> outputProperties = new HashMap<String, DBOutputTypeDesc>();
        for (int i = 0; i < resultMetaData.getColumnCount(); ++i) {
            String columnName = resultMetaData.getColumnName(i + 1);
            int columnType = resultMetaData.getColumnType(i + 1);
            String javaClass = resultMetaData.getColumnTypeName(i + 1);
            ConfigurationDBRef.ColumnChangeCaseEnum caseEnum = columnSettings.getColumnCaseConversionEnum();
            if (caseEnum != null && caseEnum == ConfigurationDBRef.ColumnChangeCaseEnum.LOWERCASE) {
                columnName = columnName.toLowerCase();
            }
            if (caseEnum != null && caseEnum == ConfigurationDBRef.ColumnChangeCaseEnum.UPPERCASE) {
                columnName = columnName.toUpperCase();
            }
            DatabaseTypeBinding binding = null;
            String javaTypeBinding = null;
            if (columnSettings != null && columnSettings.getJavaSqlTypeBinding() != null) {
                javaTypeBinding = columnSettings.getJavaSqlTypeBinding().get(columnType);
            }
            if (javaTypeBinding != null) {
                binding = DatabaseTypeEnum.getEnum(javaTypeBinding).getBinding();
            }
            DBOutputTypeDesc outputType = new DBOutputTypeDesc(columnType, javaClass, binding);
            outputProperties.put(columnName, outputType);
        }
        return outputProperties;
    }
}

