/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.esper.client.EPException;
import net.esper.collection.Pair;
import net.esper.eql.db.ConnectionCache;
import net.esper.eql.db.DBOutputTypeDesc;
import net.esper.eql.db.PollExecStrategy;
import net.esper.event.EventAdapterService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.util.DatabaseTypeBinding;
import net.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollExecStrategyDBQuery
implements PollExecStrategy {
    private static final Log log = LogFactory.getLog(PollExecStrategyDBQuery.class);
    private final EventAdapterService eventAdapterService;
    private final String preparedStatementText;
    private final Map<String, DBOutputTypeDesc> outputTypes;
    private final ConnectionCache connectionCache;
    private final EventType eventType;
    private Pair<Connection, PreparedStatement> resources;

    public PollExecStrategyDBQuery(EventAdapterService eventAdapterService, EventType eventType, ConnectionCache connectionCache, String preparedStatementText, Map<String, DBOutputTypeDesc> outputTypes) {
        this.eventAdapterService = eventAdapterService;
        this.eventType = eventType;
        this.connectionCache = connectionCache;
        this.preparedStatementText = preparedStatementText;
        this.outputTypes = outputTypes;
    }

    @Override
    public void start() {
        this.resources = this.connectionCache.getConnection();
    }

    @Override
    public void done() {
        this.connectionCache.doneWith(this.resources);
    }

    @Override
    public void destroy() {
        this.connectionCache.destroy();
    }

    @Override
    public List<EventBean> poll(Object[] lookupValues) {
        List<EventBean> result = null;
        try {
            result = this.execute(this.resources.getSecond(), lookupValues);
        }
        catch (EPException ex) {
            this.connectionCache.doneWith(this.resources);
            throw ex;
        }
        return result;
    }

    private List<EventBean> execute(PreparedStatement preparedStatement, Object[] lookupValuePerStream) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isInfoEnabled()) {
            log.info(".execute Executing prepared statement '" + this.preparedStatementText + "'");
        }
        int count = 1;
        for (int i = 0; i < lookupValuePerStream.length; ++i) {
            try {
                Object parameter = lookupValuePerStream[i];
                if (ExecutionPathDebugLog.isDebugEnabled && log.isInfoEnabled()) {
                    log.info(".execute Setting parameter " + count + " to " + parameter + " typed " + (parameter == null ? "null" : parameter.getClass()));
                }
                preparedStatement.setObject(count, lookupValuePerStream[i]);
            }
            catch (SQLException ex) {
                throw new EPException("Error setting parameter " + count, ex);
            }
            ++count;
        }
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException ex) {
            throw new EPException("Error executing statement '" + this.preparedStatementText + '\'', ex);
        }
        LinkedList<EventBean> rows = new LinkedList<EventBean>();
        try {
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (Map.Entry<String, DBOutputTypeDesc> entry : this.outputTypes.entrySet()) {
                    String columnName = entry.getKey();
                    DatabaseTypeBinding binding = entry.getValue().getOptionalBinding();
                    Object value = binding != null ? binding.getValue(resultSet, columnName) : resultSet.getObject(columnName);
                    row.put(columnName, value);
                }
                EventBean eventBeanRow = this.eventAdapterService.createMapFromValues(row, this.eventType);
                rows.add(eventBeanRow);
            }
        }
        catch (SQLException ex) {
            throw new EPException("Error reading results for statement '" + this.preparedStatementText + '\'', ex);
        }
        try {
            resultSet.close();
        }
        catch (SQLException ex) {
            throw new EPException("Error closing statement '" + this.preparedStatementText + '\'', ex);
        }
        return rows;
    }
}

