/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.lang.reflect.Array;
import java.util.LinkedList;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.CoercionException;
import net.esper.util.JavaClassHelper;

public class ExprArrayNode
extends ExprNode {
    private Class coercionType;
    private boolean mustCoerce;
    private int length;
    private Object constantResult;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        this.length = this.getChildNodes().size();
        if (this.getChildNodes().size() == 0) {
            this.coercionType = Object.class;
            this.constantResult = new Object[0];
            return;
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        for (int i = 0; i < this.length; ++i) {
            comparedTypes.add(this.getChildNodes().get(i).getType());
        }
        try {
            this.coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[0]));
            if (JavaClassHelper.isNumeric(this.coercionType)) {
                this.mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == this.coercionType) continue;
                    this.mustCoerce = true;
                }
            }
        }
        catch (CoercionException ex) {
            // empty catch block
        }
        if (this.coercionType == null) {
            this.coercionType = Object.class;
        }
        Object[] results = new Object[this.length];
        int index = 0;
        for (ExprNode child : this.getChildNodes()) {
            if (!child.isConstantResult()) {
                results = null;
                break;
            }
            results[index++] = child.evaluate(null, false);
        }
        if (results != null) {
            this.constantResult = Array.newInstance(this.coercionType, this.length);
            for (int i = 0; i < this.length; ++i) {
                if (this.mustCoerce) {
                    Number boxed = (Number)results[i];
                    if (boxed == null) continue;
                    Number coercedResult = JavaClassHelper.coerceBoxed(boxed, this.coercionType);
                    Array.set(this.constantResult, i, coercedResult);
                    continue;
                }
                Array.set(this.constantResult, i, results[i]);
            }
        }
    }

    public boolean isConstantResult() {
        return this.constantResult != null;
    }

    public Class getType() throws ExprValidationException {
        return Array.newInstance(this.coercionType, 0).getClass();
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        if (this.constantResult != null) {
            return this.constantResult;
        }
        Object array = Array.newInstance(this.coercionType, this.length);
        if (this.length == 0) {
            return array;
        }
        int index = 0;
        for (ExprNode child : this.getChildNodes()) {
            Object result = child.evaluate(eventsPerStream, isNewData);
            if (result != null) {
                if (this.mustCoerce) {
                    Number boxed = (Number)result;
                    Number coercedResult = JavaClassHelper.coerceBoxed(boxed, this.coercionType);
                    Array.set(array, index, coercedResult);
                } else {
                    Array.set(array, index, result);
                }
            }
            ++index;
        }
        return array;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "";
        buffer.append("{");
        for (ExprNode expr : this.getChildNodes()) {
            buffer.append(delimiter);
            buffer.append(expr.toExpressionString());
            delimiter = ",";
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprArrayNode;
    }
}

