/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.Iterator;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;

public class ExprBetweenNode
extends ExprNode {
    private final boolean isLowEndpointIncluded;
    private final boolean isHighEndpointIncluded;
    private final boolean isNotBetween;
    private boolean isAlwaysFalse;
    private ExprBetweenComp computer;

    public ExprBetweenNode(boolean lowEndpointIncluded, boolean highEndpointIncluded, boolean notBetween) {
        this.isLowEndpointIncluded = lowEndpointIncluded;
        this.isHighEndpointIncluded = highEndpointIncluded;
        this.isNotBetween = notBetween;
    }

    public boolean isConstantResult() {
        return false;
    }

    public boolean isLowEndpointIncluded() {
        return this.isLowEndpointIncluded;
    }

    public boolean isHighEndpointIncluded() {
        return this.isHighEndpointIncluded;
    }

    public boolean isNotBetween() {
        return this.isNotBetween;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 3) {
            throw new ExprValidationException("The Between operator requires exactly 3 child expressions");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes().get(0).getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.getChildNodes().get(1).getType());
        Class typeThree = JavaClassHelper.getBoxedType(this.getChildNodes().get(2).getType());
        if (typeOne == null) {
            throw new ExprValidationException("Null value not allowed in between-clause");
        }
        Class compareType = null;
        if (typeTwo == null || typeThree == null) {
            this.isAlwaysFalse = true;
        } else {
            if (typeOne != String.class || typeTwo != String.class || typeThree != String.class) {
                if (!JavaClassHelper.isNumeric(typeOne)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeTwo)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeThree)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeThree.getSimpleName() + "' to numeric is not allowed");
                }
            }
            Class intermedType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
            compareType = JavaClassHelper.getCompareToCoercionType(intermedType, typeThree);
            this.computer = this.makeComputer(compareType);
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        if (this.isAlwaysFalse) {
            return false;
        }
        Iterator it = this.getChildNodes().iterator();
        Object value = ((ExprNode)it.next()).evaluate(eventsPerStream, isNewData);
        if (value == null) {
            return false;
        }
        Object lower = ((ExprNode)it.next()).evaluate(eventsPerStream, isNewData);
        Object higher = ((ExprNode)it.next()).evaluate(eventsPerStream, isNewData);
        boolean result = this.computer.isBetween(value, lower, higher);
        if (this.isNotBetween) {
            return !result;
        }
        return result;
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprBetweenNode)) {
            return false;
        }
        ExprBetweenNode other = (ExprBetweenNode)node_;
        return other.isNotBetween == this.isNotBetween;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        Iterator it = this.getChildNodes().iterator();
        buffer.append(((ExprNode)it.next()).toExpressionString());
        if (this.isNotBetween) {
            buffer.append(" not between ");
        } else {
            buffer.append(" between ");
        }
        buffer.append(((ExprNode)it.next()).toExpressionString());
        buffer.append(" and ");
        buffer.append(((ExprNode)it.next()).toExpressionString());
        return buffer.toString();
    }

    private ExprBetweenComp makeComputer(Class compareType) {
        ExprBetweenComp computer = null;
        computer = compareType == String.class ? new ExprBetweenCompString(this.isLowEndpointIncluded, this.isHighEndpointIncluded) : (compareType == Long.class ? new ExprBetweenCompLong(this.isLowEndpointIncluded, this.isHighEndpointIncluded) : new ExprBetweenCompDouble(this.isLowEndpointIncluded, this.isHighEndpointIncluded));
        return computer;
    }

    private static class ExprBetweenCompLong
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompLong(boolean lowIncluded, boolean highIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
        }

        public boolean isBetween(Object value, Object lower, Object upper) {
            long upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            long valueD = ((Number)value).longValue();
            long lowerD = ((Number)lower).longValue();
            if (lowerD > (upperD = ((Number)upper).longValue())) {
                long temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD > lowerD) {
                if (valueD < upperD) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD == upperD;
                }
                return false;
            }
            return this.isLowIncluded && valueD == lowerD;
        }
    }

    private static class ExprBetweenCompDouble
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompDouble(boolean lowIncluded, boolean highIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = highIncluded;
        }

        public boolean isBetween(Object value, Object lower, Object upper) {
            double upperD;
            if (value == null || lower == null || upper == null) {
                return false;
            }
            double valueD = ((Number)value).doubleValue();
            double lowerD = ((Number)lower).doubleValue();
            if (lowerD > (upperD = ((Number)upper).doubleValue())) {
                double temp = upperD;
                upperD = lowerD;
                lowerD = temp;
            }
            if (valueD > lowerD) {
                if (valueD < upperD) {
                    return true;
                }
                if (this.isHighIncluded) {
                    return valueD == upperD;
                }
                return false;
            }
            return this.isLowIncluded && valueD == lowerD;
        }
    }

    private static class ExprBetweenCompString
    implements ExprBetweenComp {
        private boolean isLowIncluded;
        private boolean isHighIncluded;

        public ExprBetweenCompString(boolean lowIncluded, boolean isHighIncluded) {
            this.isLowIncluded = lowIncluded;
            this.isHighIncluded = isHighIncluded;
        }

        public boolean isBetween(Object value, Object lower, Object upper) {
            if (value == null || lower == null || upper == null) {
                return false;
            }
            String valueStr = (String)value;
            String upperStr = (String)upper;
            String lowerStr = (String)lower;
            if (upperStr.compareTo(lowerStr) < 0) {
                String temp = upperStr;
                upperStr = lowerStr;
                lowerStr = temp;
            }
            if (valueStr.compareTo(lowerStr) < 0) {
                return false;
            }
            if (valueStr.compareTo(upperStr) > 0) {
                return false;
            }
            if (!this.isLowIncluded && valueStr.equals(lowerStr)) {
                return false;
            }
            return this.isHighIncluded || !valueStr.equals(upperStr);
        }

        public boolean isEqualsEndpoint(Object value, Object endpoint) {
            return value.equals(endpoint);
        }
    }

    private static interface ExprBetweenComp {
        public boolean isBetween(Object var1, Object var2, Object var3);
    }
}

