/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.type.BitWiseOpEnum;
import net.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprBitWiseNode
extends ExprNode {
    private final BitWiseOpEnum _bitWiseOpEnum;
    private BitWiseOpEnum.Computer bitWiseOpEnumComputer;
    private Class resultType;
    private static final Log log = LogFactory.getLog(ExprBitWiseNode.class);

    public ExprBitWiseNode(BitWiseOpEnum bitWiseOpEnum_) {
        this._bitWiseOpEnum = bitWiseOpEnum_;
    }

    public BitWiseOpEnum getBitWiseOpEnum() {
        return this._bitWiseOpEnum;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        Class childBoxedTypeTwo;
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("BitWise node must have 2 child nodes");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType) || JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Invalid datatype for bitwise " + childType.getName() + " is not allowed");
        }
        Class childTypeOne = this.getChildNodes().get(0).getType();
        Class childTypeTwo = this.getChildNodes().get(1).getType();
        if (JavaClassHelper.isFloatingPointClass(childTypeOne) || JavaClassHelper.isFloatingPointClass(childTypeTwo)) {
            throw new ExprValidationException("Invalid type for bitwise " + this._bitWiseOpEnum.getComputeDescription() + " operator");
        }
        Class childBoxedTypeOne = JavaClassHelper.getBoxedType(childTypeOne);
        if (childBoxedTypeOne != (childBoxedTypeTwo = JavaClassHelper.getBoxedType(childTypeTwo))) {
            throw new ExprValidationException("Both nodes muts be of the same type for bitwise " + this._bitWiseOpEnum.getComputeDescription() + " operator");
        }
        this.resultType = childBoxedTypeOne;
        this.bitWiseOpEnumComputer = this._bitWiseOpEnum.getComputer(this.resultType);
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() throws ExprValidationException {
        return this.resultType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object valueChildOne = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        Object valueChildTwo = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
        if (valueChildOne == null || valueChildTwo == null) {
            return null;
        }
        return this.bitWiseOpEnumComputer.compute(valueChildOne, valueChildTwo);
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprBitWiseNode)) {
            return false;
        }
        ExprBitWiseNode other = (ExprBitWiseNode)node;
        return other._bitWiseOpEnum == this._bitWiseOpEnum;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(this._bitWiseOpEnum.getComputeDescription());
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }
}

