/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.LinkedList;
import java.util.List;
import net.esper.collection.UniformPair;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.CoercionException;
import net.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprCaseNode
extends ExprNode {
    private final boolean isCase2;
    private List<UniformPair<ExprNode>> whenThenNodeList;
    private ExprNode optionalCompareExprNode;
    private ExprNode optionalElseExprNode;
    private Class resultType;
    private boolean isNumericResult;
    private Class coercionType;
    private boolean mustCoerce;
    private static final Log log = LogFactory.getLog(ExprCaseNode.class);

    public ExprCaseNode(boolean isCase2) {
        this.isCase2 = isCase2;
    }

    public boolean isCase2() {
        return this.isCase2;
    }

    public void validate(StreamTypeService streamTypeService_, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.isCase2) {
            this.validateCaseTwo();
        } else {
            this.validateCaseOne();
        }
        LinkedList<Class> childTypes = new LinkedList<Class>();
        for (UniformPair<ExprNode> pair : this.whenThenNodeList) {
            childTypes.add(pair.getSecond().getType());
        }
        if (this.optionalElseExprNode != null) {
            childTypes.add(this.optionalElseExprNode.getType());
        }
        try {
            this.resultType = JavaClassHelper.getCommonCoercionType(childTypes.toArray(new Class[0]));
            if (JavaClassHelper.isNumeric(this.resultType)) {
                this.isNumericResult = true;
            }
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return this.resultType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        if (!this.isCase2) {
            return this.evaluateCaseSyntax1(eventsPerStream, isNewData);
        }
        return this.evaluateCaseSyntax2(eventsPerStream, isNewData);
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprCaseNode)) {
            return false;
        }
        ExprCaseNode otherExprCaseNode = (ExprCaseNode)node_;
        return this.isCase2 == otherExprCaseNode.isCase2;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("case");
        if (this.isCase2) {
            buffer.append(' ');
            buffer.append(this.getChildNodes().getFirst().toExpressionString());
        }
        for (UniformPair<ExprNode> p : this.whenThenNodeList) {
            buffer.append(" when ");
            buffer.append(p.getFirst().toExpressionString());
            buffer.append(" then ");
            buffer.append(p.getSecond().toExpressionString());
        }
        if (this.optionalElseExprNode != null) {
            buffer.append(" else ");
            buffer.append(this.optionalElseExprNode.toExpressionString());
        }
        buffer.append(" end");
        return buffer.toString();
    }

    private void validateCaseOne() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes().toArray(new ExprNode[0]);
        if (children.length < 2) {
            throw new ExprValidationException("Case node must have at least 2 child nodes");
        }
        this.whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = children.length >> 1;
        for (int i = 0; i < numWhenThen; ++i) {
            ExprNode whenExpr = children[i << 1];
            ExprNode thenExpr = children[(i << 1) + 1];
            if (whenExpr.getType() != Boolean.class) {
                throw new ExprValidationException("Case node 'when' expressions must return a boolean value");
            }
            this.whenThenNodeList.add(new UniformPair<ExprNode>(whenExpr, thenExpr));
        }
        if (children.length % 2 == 1) {
            this.optionalElseExprNode = children[children.length - 1];
        }
    }

    private void validateCaseTwo() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes().toArray(new ExprNode[0]);
        if (children.length < 3) {
            throw new ExprValidationException("Case node must have at least 3 child nodes");
        }
        this.optionalCompareExprNode = children[0];
        this.whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = (children.length - 1) / 2;
        for (int i = 0; i < numWhenThen; ++i) {
            this.whenThenNodeList.add(new UniformPair<ExprNode>(children[i * 2 + 1], children[i * 2 + 2]));
        }
        if (numWhenThen * 2 + 1 < children.length) {
            this.optionalElseExprNode = children[children.length - 1];
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        comparedTypes.add(this.optionalCompareExprNode.getType());
        for (UniformPair<ExprNode> pair : this.whenThenNodeList) {
            comparedTypes.add(pair.getFirst().getType());
        }
        try {
            this.coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[0]));
            if (JavaClassHelper.isNumeric(this.coercionType)) {
                this.mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == this.coercionType) continue;
                    this.mustCoerce = true;
                }
            }
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
    }

    private Object evaluateCaseSyntax1(EventBean[] eventsPerStream, boolean isNewData) {
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprNode> p : this.whenThenNodeList) {
            Boolean whenResult = (Boolean)p.getFirst().evaluate(eventsPerStream, isNewData);
            if (!whenResult.booleanValue()) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.resultType && this.isNumericResult) {
            return JavaClassHelper.coerceBoxed((Number)caseResult, this.resultType);
        }
        return caseResult;
    }

    private Object evaluateCaseSyntax2(EventBean[] eventsPerStream, boolean isNewData) {
        Object checkResult = this.optionalCompareExprNode.evaluate(eventsPerStream, isNewData);
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprNode> p : this.whenThenNodeList) {
            Object whenResult = p.getFirst().evaluate(eventsPerStream, isNewData);
            if (!this.compare(checkResult, whenResult)) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.resultType && this.isNumericResult) {
            return JavaClassHelper.coerceBoxed((Number)caseResult, this.resultType);
        }
        return caseResult;
    }

    private boolean compare(Object leftResult, Object rightResult) {
        if (leftResult == null) {
            return rightResult == null;
        }
        if (rightResult == null) {
            return leftResult == null;
        }
        if (!this.mustCoerce) {
            return leftResult.equals(rightResult);
        }
        Number left = JavaClassHelper.coerceBoxed((Number)leftResult, this.coercionType);
        Number right = JavaClassHelper.coerceBoxed((Number)rightResult, this.coercionType);
        return left.equals(right);
    }
}

