/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArraySet;
import net.esper.collection.Pair;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprInstanceofNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;

public class ExprCastNode
extends ExprNode {
    private final String classIdentifier;
    private Class targetType;
    private Caster caster;
    private boolean isNumeric;

    public ExprCastNode(String classIdentifier) {
        this.classIdentifier = classIdentifier;
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException("Cast function node must have exactly 1 child node");
        }
        this.targetType = JavaClassHelper.getPrimitiveClassForName(this.classIdentifier.trim());
        if (this.targetType != null) {
            this.targetType = JavaClassHelper.getBoxedType(this.targetType);
            if (this.targetType == Integer.class) {
                this.caster = new IntCaster();
                this.isNumeric = true;
            } else if (this.targetType == Long.class) {
                this.caster = new LongCaster();
                this.isNumeric = true;
            } else if (this.targetType == Double.class) {
                this.caster = new DoubleCaster();
                this.isNumeric = true;
            } else if (this.targetType == Float.class) {
                this.caster = new FloatCaster();
                this.isNumeric = true;
            } else if (this.targetType == Short.class) {
                this.caster = new ShortCaster();
                this.isNumeric = true;
            } else if (this.targetType == Byte.class) {
                this.caster = new ByteCaster();
                this.isNumeric = true;
            } else {
                this.caster = new TypeCaster(this.targetType);
            }
        } else {
            try {
                this.targetType = JavaClassHelper.getClassForName(this.classIdentifier.trim());
            }
            catch (ClassNotFoundException e) {
                throw new ExprValidationException("Class as listed in cast function by name '" + this.classIdentifier + "' cannot be loaded", e);
            }
            this.caster = new TypeCaster(this.targetType);
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() throws ExprValidationException {
        return this.targetType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object result = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        if (result == null) {
            return null;
        }
        if (this.isNumeric) {
            if (result instanceof Number) {
                return this.caster.cast(result);
            }
            return null;
        }
        if (this.targetType == String.class) {
            return result.toString();
        }
        return this.caster.cast(result);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("cast(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(", ");
        buffer.append(this.classIdentifier);
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprCastNode)) {
            return false;
        }
        ExprCastNode other = (ExprCastNode)node;
        return other.classIdentifier.equals(this.classIdentifier);
    }

    public class TypeCaster
    implements Caster {
        private Class typeToCastTo;
        private CopyOnWriteArraySet<Pair<Class, Boolean>> pairs = new CopyOnWriteArraySet();

        public TypeCaster(Class typeToCastTo) {
            this.typeToCastTo = typeToCastTo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object cast(Object object) {
            if (object.getClass() == this.typeToCastTo) {
                return object;
            }
            for (Pair<Class, Boolean> pair : this.pairs) {
                if (pair.getFirst() != this.typeToCastTo) continue;
                if (!pair.getSecond().booleanValue()) {
                    return null;
                }
                return object;
            }
            TypeCaster typeCaster = this;
            synchronized (typeCaster) {
                for (Pair<Class, Boolean> pair : this.pairs) {
                    if (pair.getFirst() != this.typeToCastTo) continue;
                    if (!pair.getSecond().booleanValue()) {
                        return null;
                    }
                    return object;
                }
                HashSet<Class> classesToCheck = new HashSet<Class>();
                ExprInstanceofNode.getSuper(object.getClass(), classesToCheck);
                if (classesToCheck.contains(this.typeToCastTo)) {
                    this.pairs.add(new Pair(object.getClass(), true));
                    return object;
                }
                this.pairs.add(new Pair(object.getClass(), false));
                return null;
            }
        }
    }

    public class ByteCaster
    implements Caster {
        public Object cast(Object object) {
            return ((Number)object).byteValue();
        }
    }

    public class ShortCaster
    implements Caster {
        public Object cast(Object object) {
            return ((Number)object).shortValue();
        }
    }

    public class IntCaster
    implements Caster {
        public Object cast(Object object) {
            return ((Number)object).intValue();
        }
    }

    public class LongCaster
    implements Caster {
        public Object cast(Object object) {
            return ((Number)object).longValue();
        }
    }

    public class FloatCaster
    implements Caster {
        public Object cast(Object object) {
            return Float.valueOf(((Number)object).floatValue());
        }
    }

    public class DoubleCaster
    implements Caster {
        public Object cast(Object object) {
            return ((Number)object).doubleValue();
        }
    }

    public static interface Caster {
        public Object cast(Object var1);
    }
}

