/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.CoercionException;
import net.esper.util.JavaClassHelper;

public class ExprCoalesceNode
extends ExprNode {
    private Class resultType;
    private boolean[] isNumericCoercion;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("Coalesce node must have at least 2 child nodes");
        }
        Class[] childTypes = new Class[this.getChildNodes().size()];
        int count = 0;
        for (ExprNode child : this.getChildNodes()) {
            childTypes[count] = child.getType();
            ++count;
        }
        try {
            this.resultType = JavaClassHelper.getCommonCoercionType(childTypes);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        this.isNumericCoercion = new boolean[this.getChildNodes().size()];
        count = 0;
        for (ExprNode child : this.getChildNodes()) {
            if (JavaClassHelper.getBoxedType(child.getType()) != this.resultType && child.getType() != null && this.resultType != null) {
                if (!JavaClassHelper.isNumeric(this.resultType)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + this.resultType.getSimpleName() + "' to " + child.getType() + " is not allowed");
                }
                this.isNumericCoercion[count] = true;
            }
            ++count;
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() throws ExprValidationException {
        return this.resultType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object value = null;
        int count = 0;
        for (ExprNode childNode : this.getChildNodes()) {
            value = childNode.evaluate(eventsPerStream, isNewData);
            if (value != null) {
                if (this.isNumericCoercion[count]) {
                    return JavaClassHelper.coerceBoxed((Number)value, this.resultType);
                }
                return value;
            }
            ++count;
        }
        return null;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("coalesce(");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            buffer.append(delimiter);
            buffer.append(this.getChildNodes().get(i).toExpressionString());
            delimiter = ",";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprCoalesceNode;
    }
}

