/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;

public class ExprConcatNode
extends ExprNode {
    private StringBuffer buffer = new StringBuffer();

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("Concat node must have at least 2 child nodes");
        }
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            Class childType = this.getChildNodes().get(i).getType();
            if (childType == String.class) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to string is not allowed");
        }
    }

    public Class getType() throws ExprValidationException {
        return String.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        this.buffer.delete(0, this.buffer.length());
        for (ExprNode child : this.getChildNodes()) {
            String result = (String)child.evaluate(eventsPerStream, isNewData);
            if (result == null) {
                return null;
            }
            this.buffer.append(result);
        }
        return this.buffer.toString();
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "(";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(delimiter);
            buffer.append(child.toExpressionString());
            delimiter = "||";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprConcatNode;
    }
}

