/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;

public class ExprConstantNode
extends ExprNode {
    private Object value;

    public ExprConstantNode(Object value) {
        this.value = value;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
    }

    public boolean isConstantResult() {
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Class getType() throws ExprValidationException {
        if (this.value == null) {
            return null;
        }
        return this.value.getClass();
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        return this.value;
    }

    public String toExpressionString() {
        if (this.value instanceof String) {
            return "\"" + this.value + '\"';
        }
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprConstantNode)) {
            return false;
        }
        ExprConstantNode other = (ExprConstantNode)node;
        if (other.value == null && this.value != null) {
            return false;
        }
        if (other.value != null && this.value == null) {
            return false;
        }
        if (other.value == null && this.value == null) {
            return true;
        }
        return other.value.equals(this.value);
    }
}

