/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;

public class ExprEqualsNode
extends ExprNode {
    private final boolean isNotEquals;
    private boolean mustCoerce;
    private Class coercionType;

    public ExprEqualsNode(boolean isNotEquals) {
        this.isNotEquals = isNotEquals;
    }

    public boolean isNotEquals() {
        return this.isNotEquals;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new IllegalStateException("Equals node does not have exactly 2 child nodes");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes().get(0).getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.getChildNodes().get(1).getType());
        if (typeOne == null || typeTwo == null) {
            return;
        }
        if (typeOne.equals(typeTwo)) {
            this.mustCoerce = false;
            return;
        }
        try {
            this.coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (IllegalArgumentException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        if (this.coercionType == JavaClassHelper.getBoxedType(typeOne) && this.coercionType == JavaClassHelper.getBoxedType(typeTwo)) {
            this.mustCoerce = false;
        } else {
            if (!JavaClassHelper.isNumeric(this.coercionType)) {
                throw new IllegalStateException("Coercion type " + this.coercionType + " not numeric");
            }
            this.mustCoerce = true;
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object leftResult = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        Object rightResult = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
        if (leftResult == null) {
            return rightResult == null ^ this.isNotEquals;
        }
        if (rightResult == null) {
            return this.isNotEquals;
        }
        if (!this.mustCoerce) {
            return leftResult.equals(rightResult) ^ this.isNotEquals;
        }
        Number left = JavaClassHelper.coerceBoxed((Number)leftResult, this.coercionType);
        Number right = JavaClassHelper.coerceBoxed((Number)rightResult, this.coercionType);
        return left.equals(right) ^ this.isNotEquals;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(" = ");
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprEqualsNode)) {
            return false;
        }
        ExprEqualsNode other = (ExprEqualsNode)node;
        return other.isNotEquals == this.isNotEquals;
    }
}

