/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.collection.Pair;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.PropertyResolutionDescriptor;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.StreamTypesException;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.event.EventPropertyGetter;
import net.esper.event.PropertyAccessException;
import net.esper.schedule.TimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprIdentNode
extends ExprNode {
    private final String unresolvedPropertyName;
    private final String streamOrPropertyName;
    private String resolvedStreamName;
    private String resolvedPropertyName;
    private EventPropertyGetter propertyGetter;
    private int streamNum = -1;
    private Class propertyType;

    public ExprIdentNode(String unresolvedPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = null;
    }

    public ExprIdentNode(String unresolvedPropertyName, String streamOrPropertyName) {
        if (unresolvedPropertyName == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        if (streamOrPropertyName == null) {
            throw new IllegalArgumentException("Stream (or property name) name is null");
        }
        this.unresolvedPropertyName = unresolvedPropertyName;
        this.streamOrPropertyName = streamOrPropertyName;
    }

    public String getUnresolvedPropertyName() {
        return this.unresolvedPropertyName;
    }

    public String getStreamOrPropertyName() {
        return this.streamOrPropertyName;
    }

    @Override
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        Pair<PropertyResolutionDescriptor, String> propertyInfoPair = ExprIdentNode.getTypeFromStream(streamTypeService, this.unresolvedPropertyName, this.streamOrPropertyName);
        this.resolvedStreamName = propertyInfoPair.getSecond();
        this.streamNum = propertyInfoPair.getFirst().getStreamNum();
        this.propertyType = propertyInfoPair.getFirst().getPropertyType();
        this.resolvedPropertyName = propertyInfoPair.getFirst().getPropertyName();
        this.propertyGetter = propertyInfoPair.getFirst().getStreamEventType().getGetter(this.resolvedPropertyName);
    }

    @Override
    public Class getType() throws ExprValidationException {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.propertyType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.streamNum;
    }

    public String getResolvedStreamName() {
        if (this.resolvedStreamName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedStreamName;
    }

    public String getResolvedPropertyName() {
        if (this.resolvedPropertyName == null) {
            throw new IllegalStateException("Identifier node has not been validated");
        }
        return this.resolvedPropertyName;
    }

    protected static Pair<PropertyResolutionDescriptor, String> getTypeFromStream(StreamTypeService streamTypeService, String unresolvedPropertyName, String streamOrPropertyName) throws ExprValidationException {
        PropertyResolutionDescriptor propertyInfo = null;
        if (streamOrPropertyName == null) {
            try {
                propertyInfo = streamTypeService.resolveByPropertyName(unresolvedPropertyName);
            }
            catch (StreamTypesException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
            catch (PropertyAccessException ex) {
                throw new ExprValidationException(ex.getMessage());
            }
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, propertyInfo.getStreamName());
        }
        try {
            propertyInfo = streamTypeService.resolveByStreamAndPropName(streamOrPropertyName, unresolvedPropertyName);
            return new Pair<PropertyResolutionDescriptor, String>(propertyInfo, streamOrPropertyName);
        }
        catch (StreamTypesException ex) {
            String propertyNameCandidate = streamOrPropertyName + '.' + unresolvedPropertyName;
            try {
                propertyInfo = streamTypeService.resolveByPropertyName(propertyNameCandidate);
                return new Pair<PropertyResolutionDescriptor, Object>(propertyInfo, null);
            }
            catch (StreamTypesException ex2) {
                throw new ExprValidationException("Failed to resolve property '" + propertyNameCandidate + "' to a stream or nested property in a stream");
            }
        }
    }

    public String toString() {
        return "unresolvedPropertyName=" + this.unresolvedPropertyName + " streamOrPropertyName=" + this.streamOrPropertyName + " resolvedPropertyName=" + this.resolvedPropertyName + " propertyInfo.pos=" + this.streamNum + " propertyInfo.type=" + this.propertyType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return this.propertyGetter.get(event);
    }

    public boolean evaluatePropertyExists(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return false;
        }
        return this.propertyGetter.isExistsProperty(event);
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        if (this.streamOrPropertyName != null) {
            buffer.append(this.streamOrPropertyName).append('.');
        }
        buffer.append(this.unresolvedPropertyName);
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprIdentNode)) {
            return false;
        }
        ExprIdentNode other = (ExprIdentNode)node;
        if (this.streamNum == -1) {
            throw new IllegalStateException("ExprIdentNode has not been validated");
        }
        return other.streamNum == this.streamNum && other.resolvedPropertyName.equals(this.resolvedPropertyName);
    }
}

