/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.Iterator;
import java.util.LinkedList;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.CoercionException;
import net.esper.util.JavaClassHelper;

public class ExprInNode
extends ExprNode {
    private final boolean isNotIn;
    private Class coercionType;
    private boolean mustCoerce;

    public ExprInNode(boolean isNotIn) {
        this.isNotIn = isNotIn;
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("The IN operator requires at least 2 child expressions");
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            comparedTypes.add(this.getChildNodes().get(i).getType());
        }
        try {
            this.coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[0]));
            if (JavaClassHelper.isNumeric(this.coercionType)) {
                this.mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == this.coercionType) continue;
                    this.mustCoerce = true;
                }
            }
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Iterator it = this.getChildNodes().iterator();
        Object inPropResult = ((ExprNode)it.next()).evaluate(eventsPerStream, isNewData);
        boolean matched = false;
        do {
            ExprNode inSetValueExpr;
            Object subExprResult;
            if (!this.compare(inPropResult, subExprResult = (inSetValueExpr = (ExprNode)it.next()).evaluate(eventsPerStream, isNewData))) continue;
            matched = true;
            break;
        } while (it.hasNext());
        if (this.isNotIn) {
            return !matched;
        }
        return matched;
    }

    public boolean isConstantResult() {
        return false;
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprInNode)) {
            return false;
        }
        ExprInNode other = (ExprInNode)node_;
        return other.isNotIn == this.isNotIn;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "";
        Iterator it = this.getChildNodes().iterator();
        buffer.append(((ExprNode)it.next()).toExpressionString());
        if (this.isNotIn) {
            buffer.append(" not in (");
        } else {
            buffer.append(" in (");
        }
        do {
            ExprNode inSetValueExpr = (ExprNode)it.next();
            buffer.append(delimiter);
            buffer.append(inSetValueExpr.toExpressionString());
            delimiter = ",";
        } while (it.hasNext());
        buffer.append(')');
        return buffer.toString();
    }

    private boolean compare(Object leftResult, Object rightResult) {
        if (leftResult == null) {
            return rightResult == null;
        }
        if (rightResult == null) {
            return false;
        }
        if (!this.mustCoerce) {
            return leftResult.equals(rightResult);
        }
        Number left = JavaClassHelper.coerceBoxed((Number)leftResult, this.coercionType);
        Number right = JavaClassHelper.coerceBoxed((Number)rightResult, this.coercionType);
        return left.equals(right);
    }
}

