/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.esper.collection.Pair;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprInstanceofNode
extends ExprNode {
    private final String[] classIdentifiers;
    private Class[] classes;
    private CopyOnWriteArrayList<Pair<Class, Boolean>> resultCache = new CopyOnWriteArrayList();

    public ExprInstanceofNode(String[] classIdentifiers) {
        this.classIdentifiers = classIdentifiers;
    }

    @Override
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException("Instanceof node must have 1 child expression node supplying the expression to test");
        }
        if (this.classIdentifiers == null || this.classIdentifiers.length == 0) {
            throw new ExprValidationException("Instanceof node must have 1 or more class identifiers to verify type against");
        }
        Set<Class> classList = this.getClassSet(this.classIdentifiers);
        this.classes = classList.toArray(new Class[0]);
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() throws ExprValidationException {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object result = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        if (result == null) {
            return false;
        }
        for (Pair<Class, Boolean> pair : this.resultCache) {
            if (pair.getFirst() != result.getClass()) continue;
            return pair.getSecond();
        }
        return this.checkAddType(result.getClass());
    }

    private synchronized Boolean checkAddType(Class type) {
        for (Pair<Class, Boolean> pair : this.resultCache) {
            if (pair.getFirst() != type) continue;
            return pair.getSecond();
        }
        HashSet<Class> classesToCheck = new HashSet<Class>();
        ExprInstanceofNode.getSuper(type, classesToCheck);
        classesToCheck.add(type);
        boolean fits = false;
        for (Class clazz : this.classes) {
            if (!classesToCheck.contains(clazz)) continue;
            fits = true;
            break;
        }
        this.resultCache.add(new Pair<Class, Boolean>(type, fits));
        return fits;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("instanceof(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(", ");
        String delimiter = "";
        for (int i = 0; i < this.classIdentifiers.length; ++i) {
            buffer.append(delimiter);
            buffer.append(this.classIdentifiers[i]);
            delimiter = ", ";
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprInstanceofNode)) {
            return false;
        }
        ExprInstanceofNode other = (ExprInstanceofNode)node;
        return Arrays.equals(other.classIdentifiers, this.classIdentifiers);
    }

    private static void getSuperInterfaces(Class clazz, Set<Class> result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            result.add(interfaces[i]);
            ExprInstanceofNode.getSuperInterfaces(interfaces[i], result);
        }
    }

    private static void getSuperClasses(Class clazz, Set<Class> result) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        result.add(superClass);
        ExprInstanceofNode.getSuper(superClass, result);
    }

    protected static void getSuper(Class clazz, Set<Class> result) {
        ExprInstanceofNode.getSuperInterfaces(clazz, result);
        ExprInstanceofNode.getSuperClasses(clazz, result);
    }

    public String[] getClassIdentifiers() {
        return this.classIdentifiers;
    }

    private Set<Class> getClassSet(String[] classIdentifiers) throws ExprValidationException {
        HashSet<Class> classList = new HashSet<Class>();
        for (String className : classIdentifiers) {
            Class clazz = JavaClassHelper.getPrimitiveClassForName(className.trim());
            if (clazz != null) {
                classList.add(clazz);
                classList.add(JavaClassHelper.getBoxedType(clazz));
                continue;
            }
            try {
                clazz = JavaClassHelper.getClassForName(className.trim());
            }
            catch (ClassNotFoundException e) {
                throw new ExprValidationException("Class as listed in instanceof function by name '" + className + "' cannot be loaded", e);
            }
            classList.add(JavaClassHelper.getPrimitiveType(clazz));
            classList.add(JavaClassHelper.getBoxedType(clazz));
        }
        return classList;
    }
}

