/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;
import net.esper.util.LikeUtil;

public class ExprLikeNode
extends ExprNode {
    private final boolean isNot;
    private boolean isNumericValue;
    private boolean isConstantPattern;
    private LikeUtil likeUtil;

    public ExprLikeNode(boolean not) {
        this.isNot = not;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        ExprNode escapeChildNode;
        if (this.getChildNodes().size() != 2 && this.getChildNodes().size() != 3) {
            throw new ExprValidationException("The 'like' operator requires 2 (no escape) or 3 (with escape) child expressions");
        }
        Class evalChildType = this.getChildNodes().get(0).getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The 'like' operator requires a String or numeric type left-hand expression");
        }
        ExprNode patternChildNode = this.getChildNodes().get(1);
        Class patternChildType = patternChildNode.getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The 'like' operator requires a String-type pattern expression");
        }
        if (this.getChildNodes().get(1).isConstantResult()) {
            this.isConstantPattern = true;
        }
        if (this.getChildNodes().size() == 3 && (escapeChildNode = this.getChildNodes().get(2)).getType() != String.class) {
            throw new ExprValidationException("The 'like' operator escape parameter requires a character-type value");
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        String patternVal;
        if (this.likeUtil == null) {
            patternVal = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
            if (patternVal == null) {
                return null;
            }
            String escape = "\\";
            Character escapeCharacter = null;
            if (this.getChildNodes().size() == 3) {
                escape = (String)this.getChildNodes().get(2).evaluate(eventsPerStream, isNewData);
            }
            if (escape.length() > 0) {
                escapeCharacter = Character.valueOf(escape.charAt(0));
            }
            this.likeUtil = new LikeUtil(patternVal, escapeCharacter, false);
        } else if (!this.isConstantPattern) {
            patternVal = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
            if (patternVal == null) {
                return null;
            }
            this.likeUtil.resetPattern(patternVal);
        }
        Object evalValue = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        if (evalValue == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.likeUtil.compare((String)evalValue);
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprLikeNode)) {
            return false;
        }
        ExprLikeNode other = (ExprLikeNode)node_;
        return this.isNot == other.isNot;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        if (this.isNot) {
            buffer.append(" not");
        }
        buffer.append(" like ");
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        if (this.getChildNodes().size() == 3) {
            buffer.append(" escape ");
            buffer.append(this.getChildNodes().get(2).toExpressionString());
        }
        return buffer.toString();
    }
}

