/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.type.MathArithTypeEnum;
import net.esper.util.JavaClassHelper;

public class ExprMathNode
extends ExprNode {
    private final MathArithTypeEnum mathArithTypeEnum;
    private MathArithTypeEnum.Computer arithTypeEnumComputer;
    private Class resultType;

    public ExprMathNode(MathArithTypeEnum mathArithTypeEnum) {
        this.mathArithTypeEnum = mathArithTypeEnum;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        Class childTypeTwo;
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("Arithmatic node must have 2 child nodes");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        Class childTypeOne = this.getChildNodes().get(0).getType();
        this.resultType = childTypeOne.equals(childTypeTwo = this.getChildNodes().get(1).getType()) ? JavaClassHelper.getBoxedType(childTypeTwo) : JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo);
        this.arithTypeEnumComputer = this.mathArithTypeEnum.getComputer(this.resultType);
    }

    public Class getType() throws ExprValidationException {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object valueChildOne = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        Object valueChildTwo = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
        if (valueChildOne == null || valueChildTwo == null) {
            return null;
        }
        return this.arithTypeEnumComputer.compute((Number)valueChildOne, (Number)valueChildTwo);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(this.mathArithTypeEnum.getExpressionText());
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprMathNode)) {
            return false;
        }
        ExprMathNode other = (ExprMathNode)node;
        return other.mathArithTypeEnum == this.mathArithTypeEnum;
    }

    public MathArithTypeEnum getMathArithTypeEnum() {
        return this.mathArithTypeEnum;
    }
}

