/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.type.MinMaxTypeEnum;

public class ExprMinMaxAggrNode
extends ExprAggregateNode {
    private final MinMaxTypeEnum minMaxTypeEnum;

    public ExprMinMaxAggrNode(boolean distinct, MinMaxTypeEnum minMaxTypeEnum) {
        super(distinct);
        this.minMaxTypeEnum = minMaxTypeEnum;
    }

    public AggregationMethod validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException(this.minMaxTypeEnum.toString() + " node must have exactly 1 child node");
        }
        ExprNode child = this.getChildNodes().get(0);
        return methodResolutionService.makeMinMaxAggregator(this.minMaxTypeEnum, child.getType());
    }

    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprMinMaxAggrNode)) {
            return false;
        }
        ExprMinMaxAggrNode other = (ExprMinMaxAggrNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    protected String getAggregationFunctionName() {
        return this.minMaxTypeEnum.getExpressionText();
    }
}

