/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.type.MinMaxTypeEnum;
import net.esper.util.JavaClassHelper;

public class ExprMinMaxRowNode
extends ExprNode {
    private MinMaxTypeEnum minMaxTypeEnum;
    private Class resultType;

    public ExprMinMaxRowNode(MinMaxTypeEnum minMaxTypeEnum) {
        this.minMaxTypeEnum = minMaxTypeEnum;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("MinMax node must have at least 2 child nodes");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        Class childTypeOne = this.getChildNodes().get(0).getType();
        Class childTypeTwo = this.getChildNodes().get(1).getType();
        this.resultType = JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo);
        for (int i = 2; i < this.getChildNodes().size(); ++i) {
            this.resultType = JavaClassHelper.getArithmaticCoercionType(this.resultType, this.getChildNodes().get(i).getType());
        }
    }

    public Class getType() throws ExprValidationException {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Number valueChildOne = (Number)this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        Number valueChildTwo = (Number)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
        if (valueChildOne == null || valueChildTwo == null) {
            return null;
        }
        Number result = null;
        if (this.minMaxTypeEnum == MinMaxTypeEnum.MAX) {
            result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildOne : (Number)valueChildTwo;
            for (int i = 2; i < this.getChildNodes().size(); ++i) {
                Number valueChild = (Number)this.getChildNodes().get(i).evaluate(eventsPerStream, isNewData);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() > result.doubleValue())) continue;
                result = valueChild;
            }
        } else {
            result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildTwo : (Number)valueChildOne;
            for (int i = 2; i < this.getChildNodes().size(); ++i) {
                Number valueChild = (Number)this.getChildNodes().get(i).evaluate(eventsPerStream, isNewData);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() < result.doubleValue())) continue;
                result = valueChild;
            }
        }
        return JavaClassHelper.coerceBoxed(result, this.resultType);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.minMaxTypeEnum.getExpressionText());
        buffer.append('(');
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        for (int i = 2; i < this.getChildNodes().size(); ++i) {
            buffer.append(',');
            buffer.append(this.getChildNodes().get(i).toExpressionString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprMinMaxRowNode)) {
            return false;
        }
        ExprMinMaxRowNode other = (ExprMinMaxRowNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum;
    }
}

