/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import net.esper.eql.agg.AggregationSupport;
import net.esper.eql.core.EngineImportException;
import net.esper.eql.core.EngineImportUndefinedException;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprConstantNode;
import net.esper.eql.expression.ExprEvaluator;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprNodeVisitor;
import net.esper.eql.expression.ExprPlugInAggFunctionNode;
import net.esper.eql.expression.ExprStaticMethodNode;
import net.esper.eql.expression.ExprStreamInstanceMethodNode;
import net.esper.eql.expression.ExprStreamUnderlyingNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.expression.ExprValidator;
import net.esper.eql.variable.VariableService;
import net.esper.schedule.TimeProvider;
import net.esper.util.MetaDefItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExprNode
implements ExprValidator,
ExprEvaluator,
MetaDefItem {
    private final LinkedList<ExprNode> childNodes = new LinkedList();
    private static final Log log = LogFactory.getLog(ExprNode.class);

    public abstract String toExpressionString();

    public abstract boolean isConstantResult();

    public abstract boolean equalsNode(ExprNode var1);

    public ExprNode getValidatedSubtree(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        ExprNode result = this;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            this.childNodes.set(i, this.childNodes.get(i).getValidatedSubtree(streamTypeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService));
        }
        try {
            this.validate(streamTypeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService);
        }
        catch (ExprValidationException e) {
            if (this instanceof ExprIdentNode) {
                ExprIdentNode identNode = (ExprIdentNode)this;
                try {
                    result = this.resolveStaticMethodOrField(identNode, streamTypeService, methodResolutionService, e, timeProvider, variableService);
                }
                catch (ExprValidationException ex) {
                    result = this.resolveAsStreamName(identNode, streamTypeService, e);
                }
            }
            if (this instanceof ExprStaticMethodNode) {
                ExprStaticMethodNode staticMethodNode = (ExprStaticMethodNode)this;
                result = this.resolveInstanceMethod(staticMethodNode, streamTypeService, methodResolutionService, e);
            }
            throw e;
        }
        return result;
    }

    private ExprNode resolveInstanceMethod(ExprStaticMethodNode staticMethodNode, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprValidationException existingException) throws ExprValidationException {
        String streamName = staticMethodNode.getClassName();
        boolean streamFound = false;
        for (String name : streamTypeService.getStreamNames()) {
            if (!name.equals(streamName)) continue;
            streamFound = true;
        }
        String methodName = staticMethodNode.getMethodName();
        ExprStreamInstanceMethodNode exprStream = new ExprStreamInstanceMethodNode(streamName, methodName);
        for (ExprNode childNode : staticMethodNode.getChildNodes()) {
            exprStream.addChildNode(childNode);
        }
        try {
            exprStream.validate(streamTypeService, methodResolutionService, null, null, null);
        }
        catch (ExprValidationException ex) {
            if (streamFound) {
                throw ex;
            }
            throw existingException;
        }
        return exprStream;
    }

    private ExprNode resolveAsStreamName(ExprIdentNode identNode, StreamTypeService streamTypeService, ExprValidationException existingException) throws ExprValidationException {
        ExprStreamUnderlyingNode exprStream = new ExprStreamUnderlyingNode(identNode.getUnresolvedPropertyName());
        try {
            exprStream.validate(streamTypeService, null, null, null, null);
        }
        catch (ExprValidationException ex) {
            throw existingException;
        }
        return exprStream;
    }

    public void accept(ExprNodeVisitor visitor) {
        if (visitor.isVisit(this)) {
            visitor.visit(this);
            for (ExprNode childNode : this.childNodes) {
                childNode.accept(visitor);
            }
        }
    }

    public final void addChildNode(ExprNode childNode) {
        this.childNodes.add(childNode);
    }

    public final LinkedList<ExprNode> getChildNodes() {
        return this.childNodes;
    }

    public final void dumpDebug(String prefix) {
        if (log.isDebugEnabled()) {
            log.debug(".dumpDebug " + prefix + this.toString());
        }
        for (ExprNode node : this.childNodes) {
            node.dumpDebug(prefix + "  ");
        }
    }

    public static boolean deepEquals(ExprNode nodeOne, ExprNode nodeTwo) {
        if (nodeOne.childNodes.size() != nodeTwo.childNodes.size()) {
            return false;
        }
        if (!nodeOne.equalsNode(nodeTwo)) {
            return false;
        }
        for (int i = 0; i < nodeOne.childNodes.size(); ++i) {
            ExprNode childNodeTwo;
            ExprNode childNodeOne = nodeOne.childNodes.get(i);
            if (ExprNode.deepEquals(childNodeOne, childNodeTwo = nodeTwo.childNodes.get(i))) continue;
            return false;
        }
        return true;
    }

    private ExprNode resolveStaticMethodOrField(ExprIdentNode identNode, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprValidationException propertyException, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        MappedPropertyParseResult parse;
        StringBuffer mappedProperty = new StringBuffer(identNode.getUnresolvedPropertyName());
        if (identNode.getStreamOrPropertyName() != null) {
            mappedProperty.insert(0, identNode.getStreamOrPropertyName() + '.');
        }
        if ((parse = ExprNode.parseMappedProperty(mappedProperty.toString())) == null) {
            ExprConstantNode constNode = this.resolveIdentAsEnumConst(mappedProperty.toString(), methodResolutionService);
            if (constNode == null) {
                throw propertyException;
            }
            return constNode;
        }
        if (parse.getClassName() != null) {
            ExprStaticMethodNode result = new ExprStaticMethodNode(parse.getClassName(), parse.getMethodName());
            result.addChildNode(new ExprConstantNode(parse.getArgString()));
            try {
                result.validate(streamTypeService, methodResolutionService, null, timeProvider, variableService);
            }
            catch (ExprValidationException e) {
                throw new ExprValidationException("Failed to resolve " + mappedProperty + " as either an event property or as a static method invocation");
            }
            return result;
        }
        try {
            AggregationSupport aggregation = methodResolutionService.resolveAggregation(parse.getMethodName());
            ExprPlugInAggFunctionNode result = new ExprPlugInAggFunctionNode(false, aggregation, parse.getMethodName());
            result.addChildNode(new ExprConstantNode(parse.getArgString()));
            try {
                result.validate(streamTypeService, methodResolutionService, null, timeProvider, variableService);
            }
            catch (RuntimeException e) {
                throw new ExprValidationException("Plug-in aggregation function '" + parse.getMethodName() + "' failed validation: " + e.getMessage());
            }
            return result;
        }
        catch (EngineImportUndefinedException e) {
        }
        catch (EngineImportException e) {
            throw new IllegalStateException("Error resolving aggregation: " + e.getMessage(), e);
        }
        throw propertyException;
    }

    private ExprConstantNode resolveIdentAsEnumConst(String constant, MethodResolutionService methodResolutionService) throws ExprValidationException {
        Field field;
        Class clazz;
        int lastDotIndex = constant.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        String className = constant.substring(0, lastDotIndex);
        String constName = constant.substring(lastDotIndex + 1);
        try {
            clazz = methodResolutionService.resolveClass(className);
        }
        catch (EngineImportException e) {
            return null;
        }
        try {
            field = clazz.getField(constName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        int modifiers = field.getModifiers();
        if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
            try {
                Object value = field.get(null);
                return new ExprConstantNode(value);
            }
            catch (IllegalAccessException e) {
                throw new ExprValidationException("Exception accessing field '" + field.getName() + "': " + e.getMessage(), e);
            }
        }
        return null;
    }

    protected static MappedPropertyParseResult parseMappedProperty(String property) {
        int indexFirstDoubleQuote = property.indexOf("\"");
        int indexFirstSingleQuote = property.indexOf("'");
        if (indexFirstSingleQuote == -1 && indexFirstDoubleQuote == -1) {
            return null;
        }
        int startArg = indexFirstSingleQuote != -1 && indexFirstDoubleQuote != -1 ? (indexFirstSingleQuote < indexFirstDoubleQuote ? indexFirstSingleQuote : indexFirstDoubleQuote) : (indexFirstSingleQuote != -1 ? indexFirstSingleQuote : indexFirstDoubleQuote);
        int indexLastDoubleQuote = property.lastIndexOf("\"");
        int indexLastSingleQuote = property.lastIndexOf("'");
        if (indexLastSingleQuote == -1 && indexLastDoubleQuote == -1) {
            return null;
        }
        int endArg = indexLastSingleQuote != -1 && indexLastDoubleQuote != -1 ? (indexLastSingleQuote > indexLastDoubleQuote ? indexLastSingleQuote : indexLastDoubleQuote) : (indexLastSingleQuote != -1 ? indexLastSingleQuote : indexLastDoubleQuote);
        String argument = property.substring(startArg + 1, endArg);
        String[] splitDots = property.split("[\\.]");
        if (splitDots.length == 0) {
            return null;
        }
        String method = splitDots[splitDots.length - 1];
        int indexParan = method.indexOf("(");
        if (indexParan == -1) {
            return null;
        }
        if ((method = method.substring(0, indexParan)).length() == 0) {
            return null;
        }
        if (splitDots.length == 1) {
            return new MappedPropertyParseResult(null, method, argument);
        }
        StringBuffer clazz = new StringBuffer();
        for (int i = 0; i < splitDots.length - 1; ++i) {
            if (i > 0) {
                clazz.append('.');
            }
            clazz.append(splitDots[i]);
        }
        return new MappedPropertyParseResult(clazz.toString(), method, argument);
    }

    protected static class MappedPropertyParseResult {
        private String className;
        private String methodName;
        private String argString;

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getArgString() {
            return this.argString;
        }

        public MappedPropertyParseResult(String className, String methodName, String argString) {
            this.className = className;
            this.methodName = methodName;
            this.argString = argString;
        }
    }
}

