/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.LinkedList;
import java.util.List;
import net.esper.collection.Pair;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprNodeIdentifierVisitor
implements ExprNodeVisitor {
    private final List<Pair<Integer, String>> exprProperties;
    private final boolean isVisitAggregateNodes;

    public ExprNodeIdentifierVisitor(boolean visitAggregateNodes) {
        this.isVisitAggregateNodes = visitAggregateNodes;
        this.exprProperties = new LinkedList<Pair<Integer, String>>();
    }

    @Override
    public boolean isVisit(ExprNode exprNode) {
        if (this.isVisitAggregateNodes) {
            return true;
        }
        return !(exprNode instanceof ExprAggregateNode);
    }

    public List<Pair<Integer, String>> getExprProperties() {
        return this.exprProperties;
    }

    @Override
    public void visit(ExprNode exprNode) {
        if (!(exprNode instanceof ExprIdentNode)) {
            return;
        }
        ExprIdentNode identNode = (ExprIdentNode)exprNode;
        int streamId = identNode.getStreamId();
        String propertyName = identNode.getResolvedPropertyName();
        this.exprProperties.add(new Pair<Integer, String>(streamId, propertyName));
    }
}

