/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;

public class ExprOrNode
extends ExprNode {
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType)) continue;
            throw new ExprValidationException("Incorrect use of OR clause, sub-expressions do not return boolean");
        }
        if (this.getChildNodes().size() <= 1) {
            throw new ExprValidationException("The OR operator requires at least 2 child expressions");
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        for (ExprNode child : this.getChildNodes()) {
            Boolean evaluated = (Boolean)child.evaluate(eventsPerStream, isNewData);
            if (!evaluated.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        String appendStr = "";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(appendStr);
            buffer.append(child.toExpressionString());
            appendStr = " OR ";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprOrNode;
    }
}

