/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.agg.AggregationMethod;
import net.esper.eql.agg.AggregationSupport;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.expression.ExprAggregateNode;
import net.esper.eql.expression.ExprValidationException;

public class ExprPlugInAggFunctionNode
extends ExprAggregateNode {
    private AggregationSupport aggregationSupport;

    public ExprPlugInAggFunctionNode(boolean distinct, AggregationSupport aggregationSupport, String functionName) {
        super(distinct);
        this.aggregationSupport = aggregationSupport;
        aggregationSupport.setFunctionName(functionName);
    }

    public AggregationMethod validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService) throws ExprValidationException {
        Class childType = null;
        if (this.getChildNodes().size() > 1) {
            throw new ExprValidationException("Plug-in aggregation function '" + this.aggregationSupport.getFunctionName() + "' requires a single parameter");
        }
        if (this.getChildNodes().size() == 1) {
            childType = this.getChildNodes().get(0).getType();
        }
        try {
            this.aggregationSupport.validate(childType);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Plug-in aggregation function '" + this.aggregationSupport.getFunctionName() + "' failed validation: " + ex.getMessage());
        }
        return this.aggregationSupport;
    }

    public String getAggregationFunctionName() {
        return this.aggregationSupport.getFunctionName();
    }

    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprPlugInAggFunctionNode)) {
            return false;
        }
        ExprPlugInAggFunctionNode other = (ExprPlugInAggFunctionNode)node;
        return other.getAggregationFunctionName().equals(this.getAggregationFunctionName());
    }
}

