/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;
import net.esper.view.ViewCapDataWindowAccess;
import net.esper.view.window.IStreamRelativeAccess;
import net.esper.view.window.RandomAccessByIndex;
import net.esper.view.window.RandomAccessByIndexGetter;
import net.esper.view.window.RelativeAccessByEventNIndexGetter;

public class ExprPreviousNode
extends ExprNode
implements ViewResourceCallback {
    private Class resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private boolean isConstantIndex;
    private RandomAccessByIndexGetter randomAccessGetter;
    private RelativeAccessByEventNIndexGetter relativeAccessGetter;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("Previous node must have 2 child nodes");
        }
        if (this.getChildNodes().get(0).isConstantResult()) {
            ExprNode constantNode = this.getChildNodes().get(0);
            Object value = constantNode.evaluate(null, false);
            if (!(value instanceof Number)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            Number valueNumber = (Number)value;
            if (JavaClassHelper.isFloatingPointNumber(valueNumber)) {
                throw new ExprValidationException("Previous function requires an integer index parameter or expression");
            }
            this.constantIndexNumber = valueNumber.intValue();
            this.isConstantIndex = true;
        }
        ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes().get(1);
        this.streamNumber = identNode.getStreamId();
        this.resultType = this.getChildNodes().get(1).getType();
        if (viewResourceDelegate == null) {
            throw new ExprValidationException("Previous function cannot be used in this context");
        }
        if (!viewResourceDelegate.requestCapability(this.streamNumber, new ViewCapDataWindowAccess(), this)) {
            throw new ExprValidationException("Previous function requires a single data window view onto the stream");
        }
    }

    public Class getType() {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Integer index;
        if (this.isConstantIndex) {
            index = this.constantIndexNumber;
        } else {
            Object indexResult = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
            if (indexResult == null) {
                return null;
            }
            index = ((Number)indexResult).intValue();
        }
        EventBean substituteEvent = null;
        if (this.randomAccessGetter != null) {
            RandomAccessByIndex randomAccess = this.randomAccessGetter.getAccessor();
            if (isNewData) {
                substituteEvent = randomAccess.getNewData(index);
            }
        } else if (isNewData) {
            EventBean evalEvent = eventsPerStream[this.streamNumber];
            IStreamRelativeAccess relativeAccess = this.relativeAccessGetter.getAccessor(evalEvent);
            substituteEvent = relativeAccess.getRelativeToEvent(evalEvent, index);
        }
        if (substituteEvent == null) {
            return null;
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("prev(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPreviousNode;
    }

    public void setViewResource(Object resource) {
        if (resource instanceof RandomAccessByIndexGetter) {
            this.randomAccessGetter = (RandomAccessByIndexGetter)resource;
        } else if (resource instanceof RelativeAccessByEventNIndexGetter) {
            this.relativeAccessGetter = (RelativeAccessByEventNIndexGetter)resource;
        } else {
            throw new IllegalArgumentException("View resource " + resource.getClass() + " not recognized by expression node");
        }
    }
}

