/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceCallback;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.view.ViewCapPriorEventAccess;
import net.esper.view.window.RandomAccessByIndex;
import net.esper.view.window.RelativeAccessByEventNIndex;

public class ExprPriorNode
extends ExprNode
implements ViewResourceCallback {
    private Class resultType;
    private int streamNumber;
    private int constantIndexNumber;
    private RelativeAccessByEventNIndex relativeAccess;
    private RandomAccessByIndex randomAccess;

    public int getConstantIndexNumber() {
        return this.constantIndexNumber;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("Prior node must have 2 child nodes");
        }
        if (!this.getChildNodes().get(0).isConstantResult()) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        ExprNode constantNode = this.getChildNodes().get(0);
        if (constantNode.getType() != Integer.class) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        Object value = constantNode.evaluate(null, false);
        this.constantIndexNumber = ((Number)value).intValue();
        ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes().get(1);
        this.streamNumber = identNode.getStreamId();
        this.resultType = this.getChildNodes().get(1).getType();
        if (viewResourceDelegate == null) {
            throw new ExprValidationException("Prior function cannot be used in this context");
        }
        if (!viewResourceDelegate.requestCapability(this.streamNumber, new ViewCapPriorEventAccess(this.constantIndexNumber), this)) {
            throw new ExprValidationException("Prior function requires the prior event view resource");
        }
    }

    public Class getType() {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        EventBean substituteEvent = null;
        substituteEvent = this.randomAccess != null ? (isNewData ? this.randomAccess.getNewData(this.constantIndexNumber) : this.randomAccess.getOldData(this.constantIndexNumber)) : this.relativeAccess.getRelativeToEvent(originalEvent, this.constantIndexNumber);
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("prior(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPriorNode;
    }

    public void setViewResource(Object resource) {
        if (resource instanceof RelativeAccessByEventNIndex) {
            this.relativeAccess = (RelativeAccessByEventNIndex)resource;
        } else if (resource instanceof RandomAccessByIndex) {
            this.randomAccess = (RandomAccessByIndex)resource;
        } else {
            throw new IllegalArgumentException("View resource " + resource.getClass() + " not recognized by expression node");
        }
    }
}

