/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprIdentNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;

public class ExprPropertyExistsNode
extends ExprNode {
    private ExprIdentNode identNode;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException("Exists function node must have exactly 1 child node");
        }
        if (!(this.getChildNodes().get(0) instanceof ExprIdentNode)) {
            throw new ExprValidationException("Exists function expects an property value expression as the child node");
        }
        this.identNode = (ExprIdentNode)this.getChildNodes().get(0);
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() throws ExprValidationException {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        return this.identNode.evaluatePropertyExists(eventsPerStream, isNewData);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("exists(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPropertyExistsNode;
    }
}

