/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.esper.client.EPException;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;

public class ExprRegexpNode
extends ExprNode {
    private final boolean isNot;
    private Pattern pattern;
    private boolean isNumericValue;
    private boolean isConstantPattern;

    public ExprRegexpNode(boolean not) {
        this.isNot = not;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("The regexp operator requires 2 child expressions");
        }
        ExprNode patternChildNode = this.getChildNodes().get(1);
        Class patternChildType = patternChildNode.getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The regexp operator requires a String-type pattern expression");
        }
        if (this.getChildNodes().get(1).isConstantResult()) {
            this.isConstantPattern = true;
        }
        Class evalChildType = this.getChildNodes().get(0).getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The regexp operator requires a String or numeric type left-hand expression");
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object evalValue;
        String patternText;
        if (this.pattern == null) {
            patternText = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if (!this.isConstantPattern) {
            patternText = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if ((evalValue = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData)) == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.pattern.matcher((String)evalValue).matches();
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprRegexpNode)) {
            return false;
        }
        ExprRegexpNode other = (ExprRegexpNode)node_;
        return this.isNot == other.isNot;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        if (this.isNot) {
            buffer.append(" not");
        }
        buffer.append(" regexp ");
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        return buffer.toString();
    }
}

