/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.type.RelationalOpEnum;
import net.esper.util.JavaClassHelper;

public class ExprRelationalOpNode
extends ExprNode {
    private final RelationalOpEnum relationalOpEnum;
    private RelationalOpEnum.Computer computer;

    public ExprRelationalOpNode(RelationalOpEnum relationalOpEnum) {
        this.relationalOpEnum = relationalOpEnum;
    }

    public boolean isConstantResult() {
        return false;
    }

    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new IllegalStateException("Relational op node does not have exactly 2 child nodes");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes().get(0).getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.getChildNodes().get(1).getType());
        if (typeOne != String.class || typeTwo != String.class) {
            if (!JavaClassHelper.isNumeric(typeOne)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
            }
            if (!JavaClassHelper.isNumeric(typeTwo)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
            }
        }
        Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        this.computer = this.relationalOpEnum.getComputer(compareType);
    }

    public Class getType() throws ExprValidationException {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        Object valueLeft = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        Object valueRight = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData);
        if (valueLeft == null || valueRight == null) {
            return false;
        }
        return this.computer.compare(valueLeft, valueRight);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(this.relationalOpEnum.getExpressionText());
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprRelationalOpNode)) {
            return false;
        }
        ExprRelationalOpNode other = (ExprRelationalOpNode)node;
        return other.relationalOpEnum == this.relationalOpEnum;
    }
}

