/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import net.esper.client.EPException;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class ExprStaticMethodNode
extends ExprNode {
    private final String className;
    private final String methodName;
    private Class[] paramTypes;
    private FastMethod staticMethod;
    private boolean isConstantParameters;
    private boolean isCachedResult;
    private Object cachedResult;

    public ExprStaticMethodNode(String className, String methodName) {
        if (className == null) {
            throw new NullPointerException("Class name is null");
        }
        if (methodName == null) {
            throw new NullPointerException("Method name is null");
        }
        this.className = className;
        this.methodName = methodName;
    }

    public boolean isConstantResult() {
        return this.isConstantParameters;
    }

    protected Method getStaticMethod() {
        return this.staticMethod.getJavaMethod();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.className);
        buffer.append('.');
        buffer.append(this.methodName);
        buffer.append('(');
        String appendString = "";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(appendString);
            buffer.append(child.toExpressionString());
            appendString = ", ";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprStaticMethodNode)) {
            return false;
        }
        if (this.staticMethod == null) {
            throw new IllegalStateException("ExprStaticMethodNode has not been validated");
        }
        ExprStaticMethodNode otherNode = (ExprStaticMethodNode)node;
        return this.staticMethod.equals(otherNode.staticMethod);
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        LinkedList<ExprNode> childNodes = this.getChildNodes();
        this.paramTypes = new Class[childNodes.size()];
        int count = 0;
        boolean allConstants = true;
        for (ExprNode childNode : childNodes) {
            this.paramTypes[count++] = childNode.getType();
            if (childNode.isConstantResult()) continue;
            allConstants = false;
        }
        this.isConstantParameters = allConstants;
        try {
            Method method = methodResolutionService.resolveMethod(this.className, this.methodName, this.paramTypes);
            FastClass declaringClass = FastClass.create(method.getDeclaringClass());
            this.staticMethod = declaringClass.getMethod(method);
        }
        catch (Exception e) {
            throw new ExprValidationException(e.getMessage());
        }
    }

    public Class getType() throws ExprValidationException {
        if (this.staticMethod == null) {
            throw new IllegalStateException("ExprStaticMethodNode has not been validated");
        }
        return this.staticMethod.getReturnType();
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        if (this.isConstantParameters && this.isCachedResult) {
            return this.cachedResult;
        }
        LinkedList<ExprNode> childNodes = this.getChildNodes();
        Object[] args = new Object[childNodes.size()];
        int count = 0;
        for (ExprNode childNode : childNodes) {
            args[count++] = childNode.evaluate(eventsPerStream, isNewData);
        }
        Object obj = null;
        try {
            Object result = this.staticMethod.invoke(obj, args);
            if (this.isConstantParameters) {
                this.cachedResult = result;
                this.isCachedResult = true;
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw new EPException(e);
        }
    }
}

