/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.event.EventType;
import net.esper.schedule.TimeProvider;

public class ExprStreamUnderlyingNode
extends ExprNode {
    private final String streamName;
    private int streamNum = -1;
    private Class type;

    public ExprStreamUnderlyingNode(String streamName) {
        if (streamName == null) {
            throw new IllegalArgumentException("Stream name is null");
        }
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        String[] streams = streamTypeService.getStreamNames();
        for (int i = 0; i < streams.length; ++i) {
            if (streams[i] == null || !streams[i].equals(this.streamName)) continue;
            this.streamNum = i;
            break;
        }
        if (this.streamNum == -1) {
            throw new ExprValidationException("Stream by name '" + this.streamName + "' could not be found among all streams");
        }
        EventType eventType = streamTypeService.getEventTypes()[this.streamNum];
        this.type = eventType.getUnderlyingType();
    }

    public Class getType() throws ExprValidationException {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.type;
    }

    public boolean isConstantResult() {
        return false;
    }

    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.streamNum;
    }

    public String toString() {
        return "streamName=" + this.streamName + " streamNum=" + this.streamNum;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return event.getUnderlying();
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.streamName);
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprStreamUnderlyingNode)) {
            return false;
        }
        ExprStreamUnderlyingNode other = (ExprStreamUnderlyingNode)node;
        return this.streamName.equals(other.streamName);
    }
}

