/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprSubselectNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.spec.StatementSpecRaw;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;
import net.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprSubselectInNode
extends ExprSubselectNode {
    private static final Log log = LogFactory.getLog(ExprSubselectInNode.class);
    private boolean isNotIn;
    private boolean mustCoerce;
    private Class coercionType;

    public ExprSubselectInNode(StatementSpecRaw statementSpec) {
        super(statementSpec);
    }

    @Override
    public Class getType() throws ExprValidationException {
        return Boolean.class;
    }

    public void setNotIn(boolean notIn) {
        this.isNotIn = notIn;
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    @Override
    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException("The Subselect-IN requires 1 child expression");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes().get(0).getType());
        Class typeTwo = this.selectClause != null ? this.selectClause.getType() : this.rawEventType.getUnderlyingType();
        if (typeOne == null || typeTwo == null) {
            return;
        }
        try {
            this.coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (IllegalArgumentException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        if (this.coercionType == JavaClassHelper.getBoxedType(typeOne) && this.coercionType == JavaClassHelper.getBoxedType(typeTwo)) {
            this.mustCoerce = false;
        } else {
            if (!JavaClassHelper.isNumeric(this.coercionType)) {
                throw new IllegalStateException("Coercion type " + this.coercionType + " not numeric");
            }
            this.mustCoerce = true;
        }
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, Set<EventBean> matchingEvents) {
        if (matchingEvents == null) {
            return this.isNotIn;
        }
        if (matchingEvents.size() == 0) {
            return this.isNotIn;
        }
        Collection<EventBean> matchedFilteredEvents = matchingEvents;
        EventBean[] events = new EventBean[eventsPerStream.length + 1];
        System.arraycopy(eventsPerStream, 0, events, 1, eventsPerStream.length);
        if (this.filterExpr != null) {
            matchedFilteredEvents = new ArrayList();
            Iterator<EventBean> i$ = matchingEvents.iterator();
            while (i$.hasNext()) {
                EventBean subselectEvent;
                events[0] = subselectEvent = i$.next();
                Boolean pass = (Boolean)this.filterExpr.evaluate(events, true);
                if (pass == null || !pass.booleanValue()) continue;
                matchedFilteredEvents.add(subselectEvent);
            }
        }
        if (matchedFilteredEvents.size() == 0) {
            return this.isNotIn;
        }
        Object leftResult = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData);
        Iterator<EventBean> i$ = matchedFilteredEvents.iterator();
        while (i$.hasNext()) {
            Number right;
            Number left;
            EventBean event;
            events[0] = event = i$.next();
            Object rightResult = this.selectClause.evaluate(events, true);
            if (!(leftResult == null ? rightResult == null : rightResult != null && (!this.mustCoerce ? leftResult.equals(rightResult) : (left = JavaClassHelper.coerceBoxed((Number)leftResult, this.coercionType)).equals(right = JavaClassHelper.coerceBoxed((Number)rightResult, this.coercionType))))) continue;
            return !this.isNotIn;
        }
        return this.isNotIn;
    }
}

