/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.expression;

import net.esper.eql.core.DuplicatePropertyException;
import net.esper.eql.core.MethodResolutionService;
import net.esper.eql.core.PropertyNotFoundException;
import net.esper.eql.core.StreamTypeService;
import net.esper.eql.core.ViewResourceDelegate;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.variable.VariableReader;
import net.esper.eql.variable.VariableService;
import net.esper.event.EventBean;
import net.esper.schedule.TimeProvider;

public class ExprVariableNode
extends ExprNode {
    private final String variableName;
    private Class variableType;
    private VariableReader reader;

    public ExprVariableNode(String variableName) {
        if (variableName == null) {
            throw new IllegalArgumentException("Variables name is null");
        }
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService) throws ExprValidationException {
        this.reader = variableService.getReader(this.variableName);
        if (this.reader == null) {
            throw new ExprValidationException("A variable by name '" + this.variableName + " has not been declared");
        }
        try {
            streamTypeService.resolveByPropertyName(this.variableName);
            throw new ExprValidationException("The variable by name '" + this.variableName + " is ambigous to a property of the same name");
        }
        catch (DuplicatePropertyException e) {
            throw new ExprValidationException("The variable by name '" + this.variableName + " is ambigous to a property of the same name");
        }
        catch (PropertyNotFoundException e) {
            this.variableType = this.reader.getType();
            return;
        }
    }

    public Class getType() throws ExprValidationException {
        if (this.variableType == null) {
            throw new IllegalStateException("Variables node has not been validated");
        }
        return this.variableType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public String toString() {
        return "variableName=" + this.variableName;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData) {
        return this.reader.getValue();
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.variableName);
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprVariableNode)) {
            return false;
        }
        ExprVariableNode other = (ExprVariableNode)node;
        return other.variableName.equals(this.variableName);
    }
}

