/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join;

import java.util.LinkedList;
import java.util.Set;
import net.esper.collection.MultiKey;
import net.esper.eql.join.QueryStrategy;
import net.esper.eql.join.exec.ExecNode;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecNodeQueryStrategy
implements QueryStrategy {
    private int forStream;
    private int numStreams;
    private ExecNode execNode;

    public ExecNodeQueryStrategy(int forStream, int numStreams, ExecNode execNode) {
        this.forStream = forStream;
        this.numStreams = numStreams;
        this.execNode = execNode;
    }

    @Override
    public void lookup(EventBean[] lookupEvents, Set<MultiKey<EventBean>> joinSet) {
        if (lookupEvents == null) {
            return;
        }
        for (EventBean event : lookupEvents) {
            EventBean[] prototype = new EventBean[this.numStreams];
            prototype[this.forStream] = event;
            LinkedList<EventBean[]> results = new LinkedList<EventBean[]>();
            this.execNode.process(event, prototype, results);
            for (EventBean[] row : results) {
                joinSet.add(new MultiKey<EventBean>(row));
            }
        }
    }

    protected int getForStream() {
        return this.forStream;
    }

    protected int getNumStreams() {
        return this.numStreams;
    }

    protected ExecNode getExecNode() {
        return this.execNode;
    }
}

