/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join;

import java.util.Iterator;
import java.util.Set;
import net.esper.collection.MultiKey;
import net.esper.eql.expression.ExprEqualsNode;
import net.esper.eql.join.HistoricalIndexLookupStrategy;
import net.esper.eql.join.PollResultIndexingStrategy;
import net.esper.eql.join.QueryStrategy;
import net.esper.eql.join.table.EventTable;
import net.esper.event.EventBean;
import net.esper.view.HistoricalEventViewable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalDataQueryStrategy
implements QueryStrategy {
    private final int myStreamNumber;
    private final int historicalStreamNumber;
    private final HistoricalEventViewable historicalEventViewable;
    private final EventBean[][] lookupRows1Event;
    private final boolean isOuterJoin;
    private final ExprEqualsNode outerJoinCompareNode;
    private final HistoricalIndexLookupStrategy indexLookupStrategy;
    private final PollResultIndexingStrategy pollResultIndexingStrategy;

    public HistoricalDataQueryStrategy(int myStreamNumber, int historicalStreamNumber, HistoricalEventViewable historicalEventViewable, boolean isOuterJoin, ExprEqualsNode outerJoinCompareNode, HistoricalIndexLookupStrategy indexLookupStrategy, PollResultIndexingStrategy pollResultIndexingStrategy) {
        this.myStreamNumber = myStreamNumber;
        this.historicalStreamNumber = historicalStreamNumber;
        this.historicalEventViewable = historicalEventViewable;
        this.isOuterJoin = isOuterJoin;
        this.outerJoinCompareNode = outerJoinCompareNode;
        this.lookupRows1Event = new EventBean[1][];
        this.lookupRows1Event[0] = new EventBean[2];
        this.indexLookupStrategy = indexLookupStrategy;
        this.pollResultIndexingStrategy = pollResultIndexingStrategy;
    }

    @Override
    public void lookup(EventBean[] lookupEvents, Set<MultiKey<EventBean>> joinSet) {
        EventBean[][] lookupRows;
        if (lookupEvents.length == 1) {
            lookupRows = this.lookupRows1Event;
            lookupRows[0][this.myStreamNumber] = lookupEvents[0];
        } else {
            lookupRows = new EventBean[lookupEvents.length][];
            for (int i = 0; i < lookupEvents.length; ++i) {
                lookupRows[i] = new EventBean[2];
                lookupRows[i][this.myStreamNumber] = lookupEvents[i];
            }
        }
        EventTable[] indexPerLookupRow = this.historicalEventViewable.poll(lookupRows, this.pollResultIndexingStrategy);
        int count = 0;
        for (EventTable index : indexPerLookupRow) {
            EventBean[] resultRow;
            Iterator<EventBean> subsetIter = this.indexLookupStrategy.lookup(lookupEvents[count], index);
            if (this.isOuterJoin && (subsetIter == null || !subsetIter.hasNext())) {
                resultRow = new EventBean[2];
                resultRow[this.myStreamNumber] = lookupEvents[count];
                joinSet.add(new MultiKey<EventBean>(resultRow));
            } else if (subsetIter != null) {
                while (subsetIter.hasNext()) {
                    resultRow = new EventBean[2];
                    resultRow[this.myStreamNumber] = lookupEvents[count];
                    resultRow[this.historicalStreamNumber] = subsetIter.next();
                    if (this.isOuterJoin) {
                        Boolean compareResult = (Boolean)this.outerJoinCompareNode.evaluate(resultRow, true);
                        if (compareResult == null || !compareResult.booleanValue()) continue;
                        joinSet.add(new MultiKey<EventBean>(resultRow));
                        continue;
                    }
                    joinSet.add(new MultiKey<EventBean>(resultRow));
                }
            }
            ++count;
        }
    }
}

