/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join;

import java.util.HashMap;
import java.util.Map;
import net.esper.collection.FlushedEventBuffer;
import net.esper.core.EPStatementDispatch;
import net.esper.eql.join.JoinExecutionStrategy;
import net.esper.event.EventBean;
import net.esper.view.internal.BufferObserver;

public class JoinExecStrategyDispatchable
implements EPStatementDispatch,
BufferObserver {
    private final JoinExecutionStrategy joinExecutionStrategy;
    private final Map<Integer, FlushedEventBuffer> oldStreamBuffer;
    private final Map<Integer, FlushedEventBuffer> newStreamBuffer;
    private final int numStreams;
    private boolean hasNewData;

    public JoinExecStrategyDispatchable(JoinExecutionStrategy joinExecutionStrategy, int numStreams) {
        this.joinExecutionStrategy = joinExecutionStrategy;
        this.numStreams = numStreams;
        this.oldStreamBuffer = new HashMap<Integer, FlushedEventBuffer>();
        this.newStreamBuffer = new HashMap<Integer, FlushedEventBuffer>();
    }

    public void execute() {
        if (!this.hasNewData) {
            return;
        }
        this.hasNewData = false;
        EventBean[][] oldDataPerStream = new EventBean[this.numStreams][];
        EventBean[][] newDataPerStream = new EventBean[this.numStreams][];
        for (int i = 0; i < this.numStreams; ++i) {
            oldDataPerStream[i] = JoinExecStrategyDispatchable.getBufferData(this.oldStreamBuffer.get(i));
            newDataPerStream[i] = JoinExecStrategyDispatchable.getBufferData(this.newStreamBuffer.get(i));
        }
        this.joinExecutionStrategy.join(newDataPerStream, oldDataPerStream);
    }

    private static EventBean[] getBufferData(FlushedEventBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return buffer.getAndFlush();
    }

    public void newData(int streamId, FlushedEventBuffer newEventBuffer, FlushedEventBuffer oldEventBuffer) {
        this.hasNewData = true;
        this.newStreamBuffer.put(streamId, newEventBuffer);
        this.oldStreamBuffer.put(streamId, oldEventBuffer);
    }
}

