/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join;

import java.util.Set;
import net.esper.collection.MultiKey;
import net.esper.collection.UniformPair;
import net.esper.eql.join.JoinExecutionStrategy;
import net.esper.eql.join.JoinSetComposer;
import net.esper.eql.join.JoinSetProcessor;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinExecutionStrategyImpl
implements JoinExecutionStrategy {
    private final JoinSetComposer composer;
    private final JoinSetProcessor filter;
    private final JoinSetProcessor indicator;

    public JoinExecutionStrategyImpl(JoinSetComposer composer, JoinSetProcessor filter, JoinSetProcessor indicator) {
        this.composer = composer;
        this.filter = filter;
        this.indicator = indicator;
    }

    @Override
    public void join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream) {
        UniformPair<Set<MultiKey<EventBean>>> joinSet = this.composer.join(newDataPerStream, oldDataPerStream);
        this.filter.process(joinSet.getFirst(), joinSet.getSecond());
        if (!joinSet.getFirst().isEmpty() || !joinSet.getSecond().isEmpty()) {
            this.indicator.process(joinSet.getFirst(), joinSet.getSecond());
        }
    }

    @Override
    public Set<MultiKey<EventBean>> staticJoin() {
        Set<MultiKey<EventBean>> joinSet = this.composer.staticJoin();
        this.filter.process(joinSet, null);
        return joinSet;
    }
}

