/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join;

import java.util.List;
import net.esper.collection.Pair;
import net.esper.eql.expression.ExprAndNode;
import net.esper.eql.expression.ExprEqualsNode;
import net.esper.eql.expression.ExprNode;
import net.esper.eql.expression.ExprValidationException;
import net.esper.eql.join.ExecNodeQueryStrategy;
import net.esper.eql.join.HistoricalDataQueryStrategy;
import net.esper.eql.join.HistoricalIndexLookupStrategy;
import net.esper.eql.join.HistoricalIndexLookupStrategyIndex;
import net.esper.eql.join.HistoricalIndexLookupStrategyNoIndex;
import net.esper.eql.join.JoinSetComposer;
import net.esper.eql.join.JoinSetComposerFactory;
import net.esper.eql.join.JoinSetComposerImpl;
import net.esper.eql.join.PollResultIndexingStrategy;
import net.esper.eql.join.PollResultIndexingStrategyIndex;
import net.esper.eql.join.PollResultIndexingStrategyIndexCoerce;
import net.esper.eql.join.PollResultIndexingStrategyNoIndex;
import net.esper.eql.join.QueryStrategy;
import net.esper.eql.join.exec.ExecNode;
import net.esper.eql.join.plan.FilterExprAnalyzer;
import net.esper.eql.join.plan.QueryGraph;
import net.esper.eql.join.plan.QueryPlan;
import net.esper.eql.join.plan.QueryPlanBuilder;
import net.esper.eql.join.plan.QueryPlanIndex;
import net.esper.eql.join.plan.QueryPlanNode;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.join.table.PropertyIndTableCoerceAll;
import net.esper.eql.join.table.PropertyIndexedEventTable;
import net.esper.eql.join.table.UnindexedEventTable;
import net.esper.eql.spec.OuterJoinDesc;
import net.esper.eql.spec.SelectClauseStreamSelectorEnum;
import net.esper.event.EventType;
import net.esper.type.OuterJoinType;
import net.esper.util.JavaClassHelper;
import net.esper.view.HistoricalEventViewable;
import net.esper.view.Viewable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinSetComposerFactoryImpl
implements JoinSetComposerFactory {
    private static final Log log = LogFactory.getLog(JoinSetComposerFactoryImpl.class);

    @Override
    public JoinSetComposer makeComposer(List<OuterJoinDesc> outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, String[] streamNames, Viewable[] streamViews, SelectClauseStreamSelectorEnum selectStreamSelectorEnum) throws ExprValidationException {
        QueryStrategy[] queryStrategies;
        EventTable[][] indexes;
        boolean hasHistorical = false;
        for (int i = 0; i < streamViews.length; ++i) {
            if (!(streamViews[i] instanceof HistoricalEventViewable)) continue;
            if (hasHistorical) {
                throw new ExprValidationException("Joins between historical data streams are not supported");
            }
            hasHistorical = true;
            if (streamTypes.length <= 2) continue;
            throw new ExprValidationException("Joins between historical data require a only one event stream in the join");
        }
        if (hasHistorical) {
            Pair<EventTable[][], QueryStrategy[]> indexAndStrategies = this.makeComposerHistorical(outerJoinDescList, optionalFilterNode, streamTypes, streamViews);
            indexes = indexAndStrategies.getFirst();
            queryStrategies = indexAndStrategies.getSecond();
        } else {
            QueryPlan queryPlan = QueryPlanBuilder.getPlan(streamTypes, outerJoinDescList, optionalFilterNode, streamNames);
            QueryPlanIndex[] indexSpecs = queryPlan.getIndexSpecs();
            indexes = new EventTable[indexSpecs.length][];
            for (int streamNo = 0; streamNo < indexSpecs.length; ++streamNo) {
                String[][] indexProps = indexSpecs[streamNo].getIndexProps();
                Class[][] coercionTypes = indexSpecs[streamNo].getCoercionTypesPerIndex();
                indexes[streamNo] = new EventTable[indexProps.length];
                for (int indexNo = 0; indexNo < indexProps.length; ++indexNo) {
                    indexes[streamNo][indexNo] = JoinSetComposerFactoryImpl.buildIndex(streamNo, indexProps[indexNo], coercionTypes[indexNo], streamTypes[streamNo]);
                }
            }
            QueryPlanNode[] queryExecSpecs = queryPlan.getExecNodeSpecs();
            queryStrategies = new QueryStrategy[queryExecSpecs.length];
            for (int i = 0; i < queryExecSpecs.length; ++i) {
                QueryPlanNode planNode = queryExecSpecs[i];
                ExecNode executionNode = planNode.makeExec(indexes, streamTypes);
                if (log.isDebugEnabled()) {
                    log.debug(".makeComposer Execution nodes for stream " + i + " '" + streamNames[i] + "' : \n" + ExecNode.print(executionNode));
                }
                queryStrategies[i] = new ExecNodeQueryStrategy(i, streamTypes.length, executionNode);
            }
        }
        return new JoinSetComposerImpl(indexes, queryStrategies, selectStreamSelectorEnum);
    }

    private Pair<EventTable[][], QueryStrategy[]> makeComposerHistorical(List<OuterJoinDesc> outerJoinDescList, ExprNode optionalFilterNode, EventType[] streamTypes, Viewable[] streamViews) throws ExprValidationException {
        EventTable[][] indexes = new EventTable[streamTypes.length][];
        QueryStrategy[] queryStrategies = new QueryStrategy[streamTypes.length];
        for (int streamNo = 0; streamNo < streamTypes.length; ++streamNo) {
            indexes[streamNo] = new EventTable[0];
        }
        int polledView = 0;
        int streamView = 1;
        if (streamViews[1] instanceof HistoricalEventViewable) {
            streamView = 0;
            polledView = 1;
        }
        boolean isOuterJoin = false;
        ExprEqualsNode outerJoinEqualsNode = null;
        if (!outerJoinDescList.isEmpty()) {
            OuterJoinDesc outerJoinDesc = outerJoinDescList.get(0);
            if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.FULL)) {
                isOuterJoin = true;
            } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.LEFT) && streamView == 0) {
                isOuterJoin = true;
            } else if (outerJoinDesc.getOuterJoinType().equals((Object)OuterJoinType.RIGHT) && streamView == 1) {
                isOuterJoin = true;
            }
            outerJoinEqualsNode = new ExprEqualsNode(false);
            outerJoinEqualsNode.addChildNode(outerJoinDesc.getLeftNode());
            outerJoinEqualsNode.addChildNode(outerJoinDesc.getRightNode());
            outerJoinEqualsNode.validate(null, null, null, null, null);
        }
        ExprNode filterForIndexing = null;
        if (outerJoinEqualsNode != null && optionalFilterNode != null) {
            filterForIndexing = new ExprAndNode();
            filterForIndexing.addChildNode(optionalFilterNode);
            filterForIndexing.addChildNode(outerJoinEqualsNode);
        } else if (outerJoinEqualsNode == null && optionalFilterNode != null) {
            filterForIndexing = optionalFilterNode;
        } else if (outerJoinEqualsNode != null) {
            filterForIndexing = outerJoinEqualsNode;
        }
        Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> indexStrategies = this.determineIndexing(filterForIndexing, streamTypes[polledView], streamTypes[streamView], polledView, streamView);
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[polledView];
        queryStrategies[streamView] = new HistoricalDataQueryStrategy(streamView, polledView, viewable, isOuterJoin, outerJoinEqualsNode, indexStrategies.getFirst(), indexStrategies.getSecond());
        return new Pair<EventTable[][], QueryStrategy[]>(indexes, queryStrategies);
    }

    private Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> determineIndexing(ExprNode filterForIndexing, EventType polledViewType, EventType streamViewType, int polledViewStreamNum, int streamViewStreamNum) {
        HistoricalIndexLookupStrategyIndex strategy;
        if (filterForIndexing == null) {
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        QueryGraph queryGraph = new QueryGraph(2);
        FilterExprAnalyzer.analyze(filterForIndexing, queryGraph);
        String[] keyPropertiesJoin = queryGraph.getKeyProperties(streamViewStreamNum, polledViewStreamNum);
        String[] indexPropertiesJoin = queryGraph.getIndexProperties(streamViewStreamNum, polledViewStreamNum);
        if (keyPropertiesJoin == null || keyPropertiesJoin.length == 0) {
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(new HistoricalIndexLookupStrategyNoIndex(), new PollResultIndexingStrategyNoIndex());
        }
        boolean mustCoerce = false;
        Class[] coercionTypes = new Class[indexPropertiesJoin.length];
        for (int i = 0; i < keyPropertiesJoin.length; ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(streamViewType.getPropertyType(keyPropertiesJoin[i]));
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(polledViewType.getPropertyType(indexPropertiesJoin[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        if (!mustCoerce) {
            PollResultIndexingStrategyIndex indexing = new PollResultIndexingStrategyIndex(polledViewStreamNum, polledViewType, indexPropertiesJoin);
            strategy = new HistoricalIndexLookupStrategyIndex(streamViewType, keyPropertiesJoin);
            return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
        }
        PollResultIndexingStrategyIndexCoerce indexing = new PollResultIndexingStrategyIndexCoerce(polledViewStreamNum, polledViewType, indexPropertiesJoin, coercionTypes);
        strategy = new HistoricalIndexLookupStrategyIndex(streamViewType, keyPropertiesJoin);
        return new Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy>(strategy, indexing);
    }

    protected static EventTable buildIndex(int indexedStreamNum, String[] indexProps, Class[] optCoercionTypes, EventType eventType) {
        EventTable table = null;
        table = indexProps.length == 0 ? new UnindexedEventTable(indexedStreamNum) : (optCoercionTypes == null ? new PropertyIndexedEventTable(indexedStreamNum, eventType, indexProps) : new PropertyIndTableCoerceAll(indexedStreamNum, eventType, indexProps, optCoercionTypes));
        return table;
    }
}

