/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.esper.collection.MultiKey;
import net.esper.collection.UniformPair;
import net.esper.eql.join.JoinSetComposer;
import net.esper.eql.join.QueryStrategy;
import net.esper.eql.join.table.EventTable;
import net.esper.eql.spec.SelectClauseStreamSelectorEnum;
import net.esper.event.EventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinSetComposerImpl
implements JoinSetComposer {
    private final EventTable[][] repositories;
    private final QueryStrategy[] queryStrategies;
    private final SelectClauseStreamSelectorEnum selectStreamSelectorEnum;
    private Set<MultiKey<EventBean>> oldResults = new LinkedHashSet<MultiKey<EventBean>>();
    private Set<MultiKey<EventBean>> newResults = new LinkedHashSet<MultiKey<EventBean>>();

    public JoinSetComposerImpl(EventTable[][] repositories, QueryStrategy[] queryStrategies, SelectClauseStreamSelectorEnum selectStreamSelectorEnum) {
        this.repositories = repositories;
        this.queryStrategies = queryStrategies;
        this.selectStreamSelectorEnum = selectStreamSelectorEnum;
    }

    @Override
    public void init(EventBean[][] eventsPerStream) {
        for (int i = 0; i < eventsPerStream.length; ++i) {
            if (eventsPerStream[i] == null) continue;
            for (int j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(eventsPerStream[i]);
            }
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.repositories.length; ++i) {
            for (EventTable table : this.repositories[i]) {
                table.clear();
            }
        }
    }

    @Override
    public UniformPair<Set<MultiKey<EventBean>>> join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream) {
        int j;
        int i;
        this.oldResults.clear();
        this.newResults.clear();
        if (!this.selectStreamSelectorEnum.equals((Object)SelectClauseStreamSelectorEnum.ISTREAM_ONLY)) {
            for (i = 0; i < oldDataPerStream.length; ++i) {
                if (oldDataPerStream[i] == null) continue;
                this.queryStrategies[i].lookup(oldDataPerStream[i], this.oldResults);
            }
        }
        for (i = 0; i < newDataPerStream.length; ++i) {
            if (newDataPerStream[i] == null) continue;
            for (j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(newDataPerStream[i]);
            }
        }
        for (i = 0; i < oldDataPerStream.length; ++i) {
            if (oldDataPerStream[i] == null) continue;
            for (j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].remove(oldDataPerStream[i]);
            }
        }
        if (!this.selectStreamSelectorEnum.equals((Object)SelectClauseStreamSelectorEnum.RSTREAM_ONLY)) {
            for (i = 0; i < newDataPerStream.length; ++i) {
                if (newDataPerStream[i] == null) continue;
                this.queryStrategies[i].lookup(newDataPerStream[i], this.newResults);
            }
        }
        return new UniformPair<Set<MultiKey<EventBean>>>(this.newResults, this.oldResults);
    }

    protected EventTable[][] getTables() {
        return this.repositories;
    }

    protected QueryStrategy[] getQueryStrategies() {
        return this.queryStrategies;
    }

    @Override
    public Set<MultiKey<EventBean>> staticJoin() {
        LinkedHashSet<MultiKey<EventBean>> result = new LinkedHashSet<MultiKey<EventBean>>();
        EventBean[] lookupEvents = new EventBean[1];
        for (int stream = 0; stream < this.queryStrategies.length; ++stream) {
            Iterator<EventBean> streamEvents = this.repositories[stream][0].iterator();
            while (streamEvents.hasNext()) {
                lookupEvents[0] = streamEvents.next();
                this.queryStrategies[stream].lookup(lookupEvents, result);
            }
        }
        return result;
    }
}

