/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.assemble;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Map;
import net.esper.eql.join.assemble.BaseAssemblyNode;
import net.esper.eql.join.assemble.BranchOptionalAssemblyNode;
import net.esper.eql.join.assemble.BranchRequiredAssemblyNode;
import net.esper.eql.join.assemble.CartesianProdAssemblyNode;
import net.esper.eql.join.assemble.LeafAssemblyNode;
import net.esper.eql.join.assemble.RootCartProdAssemblyNode;
import net.esper.eql.join.assemble.RootOptionalAssemblyNode;
import net.esper.eql.join.assemble.RootRequiredAssemblyNode;
import net.esper.eql.join.plan.NStreamOuterQueryPlanBuilder;
import net.esper.util.IndentWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyStrategyTreeBuilder {
    private static final Log log = LogFactory.getLog(AssemblyStrategyTreeBuilder.class);

    public static BaseAssemblyNode build(int rootStream, Map<Integer, int[]> streamsJoinedPerStream, boolean[] isRequiredPerStream) {
        if (streamsJoinedPerStream.size() < 3) {
            throw new IllegalArgumentException("Not a 3-way join");
        }
        if (rootStream < 0 || rootStream >= streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Invalid root stream");
        }
        if (isRequiredPerStream.length != streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Arrays not matching up");
        }
        NStreamOuterQueryPlanBuilder.verifyJoinedPerStream(rootStream, streamsJoinedPerStream);
        if (log.isDebugEnabled()) {
            log.debug(".build Building node for root stream " + rootStream + " streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream) + " isRequiredPerStream=" + Arrays.toString(isRequiredPerStream));
        }
        BaseAssemblyNode topNode = AssemblyStrategyTreeBuilder.createNode(true, rootStream, streamsJoinedPerStream.size(), streamsJoinedPerStream.get(rootStream), isRequiredPerStream);
        AssemblyStrategyTreeBuilder.recursiveBuild(rootStream, topNode, streamsJoinedPerStream, isRequiredPerStream);
        if (log.isDebugEnabled()) {
            StringWriter buf = new StringWriter();
            PrintWriter print = new PrintWriter(buf);
            IndentWriter indentWriter = new IndentWriter(print, 0, 2);
            topNode.printDescendends(indentWriter);
            log.debug(".build Dumping root node for stream " + rootStream + ": \n" + buf.toString());
        }
        return topNode;
    }

    private static void recursiveBuild(int parentStreamNum, BaseAssemblyNode parentNode, Map<Integer, int[]> streamsJoinedPerStream, boolean[] isRequiredPerStream) {
        int numStreams = streamsJoinedPerStream.size();
        for (int i = 0; i < streamsJoinedPerStream.get(parentStreamNum).length; ++i) {
            int streamJoined = streamsJoinedPerStream.get(parentStreamNum)[i];
            BaseAssemblyNode childNode = AssemblyStrategyTreeBuilder.createNode(false, streamJoined, numStreams, streamsJoinedPerStream.get(streamJoined), isRequiredPerStream);
            parentNode.addChild(childNode);
            if (streamsJoinedPerStream.get(streamJoined).length <= 0) continue;
            AssemblyStrategyTreeBuilder.recursiveBuild(streamJoined, childNode, streamsJoinedPerStream, isRequiredPerStream);
        }
    }

    private static BaseAssemblyNode createNode(boolean isRoot, int streamNum, int numStreams, int[] joinedStreams, boolean[] isRequiredPerStream) {
        if (joinedStreams.length == 0) {
            return new LeafAssemblyNode(streamNum, numStreams);
        }
        if (joinedStreams.length == 1) {
            int joinedStream = joinedStreams[0];
            boolean isRequired = isRequiredPerStream[joinedStream];
            if (isRequired) {
                if (isRoot) {
                    return new RootRequiredAssemblyNode(streamNum, numStreams);
                }
                return new BranchRequiredAssemblyNode(streamNum, numStreams);
            }
            if (isRoot) {
                return new RootOptionalAssemblyNode(streamNum, numStreams);
            }
            return new BranchOptionalAssemblyNode(streamNum, numStreams);
        }
        boolean allSubStreamsOptional = true;
        for (int i = 0; i < joinedStreams.length; ++i) {
            int stream = joinedStreams[i];
            if (!isRequiredPerStream[stream]) continue;
            allSubStreamsOptional = false;
        }
        if (isRoot) {
            return new RootCartProdAssemblyNode(streamNum, numStreams, allSubStreamsOptional);
        }
        return new CartesianProdAssemblyNode(streamNum, numStreams, allSubStreamsOptional);
    }
}

