/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.assemble;

import java.util.List;
import java.util.Set;
import net.esper.eql.join.assemble.BaseAssemblyNode;
import net.esper.eql.join.rep.Node;
import net.esper.event.EventBean;
import net.esper.util.IndentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafAssemblyNode
extends BaseAssemblyNode {
    public LeafAssemblyNode(int streamNum, int numStreams) {
        super(streamNum, numStreams);
    }

    @Override
    public void init(List<Node>[] result) {
    }

    @Override
    public void process(List<Node>[] result) {
        List<Node> nodes = result[this.streamNum];
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            Set<EventBean> events = node.getEvents();
            for (EventBean event : events) {
                this.processEvent(event, node);
            }
        }
    }

    private void processEvent(EventBean event, Node currentNode) {
        EventBean[] row = new EventBean[this.numStreams];
        row[this.streamNum] = event;
        this.parentNode.result(row, this.streamNum, currentNode.getParentEvent(), currentNode.getParent());
    }

    @Override
    public void result(EventBean[] row, int streamNum, EventBean myEvent, Node myNode) {
        throw new UnsupportedOperationException("Leaf node cannot process child results");
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("LeafAssemblyNode streamNum=" + this.streamNum);
    }
}

