/*
 * Decompiled with CFR 0.152.
 */
package net.esper.eql.join.exec;

import java.util.LinkedList;
import java.util.List;
import net.esper.eql.join.exec.ExecNode;
import net.esper.event.EventBean;
import net.esper.util.IndentWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedIterationExecNode
extends ExecNode {
    private final LinkedList<ExecNode> childNodes;
    private final int[] nestedStreams;
    private int nestingOrderLength;

    public NestedIterationExecNode(int[] nestedStreams) {
        this.nestedStreams = nestedStreams;
        this.childNodes = new LinkedList();
    }

    public void addChildNode(ExecNode childNode) {
        this.childNodes.add(childNode);
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, List<EventBean[]> result) {
        this.nestingOrderLength = this.childNodes.size();
        this.recursiveNestedJoin(lookupEvent, 0, prefillPath, result);
    }

    protected void recursiveNestedJoin(EventBean lookupEvent, int nestingOrderIndex, EventBean[] currentPath, List<EventBean[]> result) {
        boolean isLastStream;
        LinkedList<EventBean[]> nestedResult = new LinkedList<EventBean[]>();
        ExecNode nestedExecNode = this.childNodes.get(nestingOrderIndex);
        nestedExecNode.process(lookupEvent, currentPath, nestedResult);
        boolean bl = isLastStream = nestingOrderIndex == this.nestingOrderLength - 1;
        if (!isLastStream) {
            for (EventBean[] row : nestedResult) {
                EventBean lookup = row[this.nestedStreams[nestingOrderIndex]];
                this.recursiveNestedJoin(lookup, nestingOrderIndex + 1, row, result);
            }
            return;
        }
        for (EventBean[] row : nestedResult) {
            result.add(row);
        }
    }

    @Override
    public void print(IndentWriter writer) {
        writer.println("NestedIterationExecNode");
        writer.incrIndent();
        for (ExecNode child : this.childNodes) {
            child.print(writer);
        }
        writer.decrIndent();
    }
}

